/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import org.apache.qpid.server.filter.BinaryExpression;
import org.apache.qpid.server.filter.BooleanExpression;

public abstract class LogicExpression<T>
extends BinaryExpression<T>
implements BooleanExpression<T> {
    public static <E> BooleanExpression<E> createOR(BooleanExpression<E> lvalue, BooleanExpression<E> rvalue) {
        return new OrExpression<E>(lvalue, rvalue);
    }

    public static <E> BooleanExpression<E> createAND(BooleanExpression<E> lvalue, BooleanExpression<E> rvalue) {
        return new AndExpression<E>(lvalue, rvalue);
    }

    public LogicExpression(BooleanExpression<T> left, BooleanExpression<T> right) {
        super(left, right);
    }

    @Override
    public abstract Object evaluate(T var1);

    @Override
    public boolean matches(T message) {
        Object object = this.evaluate(message);
        return object != null && object == Boolean.TRUE;
    }

    private static class OrExpression<E>
    extends LogicExpression<E> {
        public OrExpression(BooleanExpression<E> lvalue, BooleanExpression<E> rvalue) {
            super(lvalue, rvalue);
        }

        @Override
        public Object evaluate(E message) {
            Boolean lv = (Boolean)this.getLeft().evaluate(message);
            if (lv != null && lv.booleanValue()) {
                return Boolean.TRUE;
            }
            Boolean rv = (Boolean)this.getRight().evaluate(message);
            return rv == null ? null : rv;
        }

        @Override
        public String getExpressionSymbol() {
            return "OR";
        }
    }

    private static class AndExpression<E>
    extends LogicExpression<E> {
        public AndExpression(BooleanExpression<E> lvalue, BooleanExpression<E> rvalue) {
            super(lvalue, rvalue);
        }

        @Override
        public Object evaluate(E message) {
            Boolean lv = (Boolean)this.getLeft().evaluate(message);
            if (lv == null) {
                return null;
            }
            if (!lv.booleanValue()) {
                return Boolean.FALSE;
            }
            Boolean rv = (Boolean)this.getRight().evaluate(message);
            return rv == null ? null : rv;
        }

        @Override
        public String getExpressionSymbol() {
            return "AND";
        }
    }
}

