/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBodyImpl;
import org.apache.qpid.server.protocol.v0_8.transport.ClientChannelMethodProcessor;
import org.apache.qpid.server.protocol.v0_8.transport.EncodableAMQDataBlock;
import org.apache.qpid.server.protocol.v0_8.transport.MethodDispatcher;

public class BasicGetOkBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 60;
    public static final int METHOD_ID = 71;
    private final long _deliveryTag;
    private final byte _bitfield0;
    private final AMQShortString _exchange;
    private final AMQShortString _routingKey;
    private final long _messageCount;

    public BasicGetOkBody(long deliveryTag, boolean redelivered, AMQShortString exchange, AMQShortString routingKey, long messageCount) {
        this._deliveryTag = deliveryTag;
        byte bitfield0 = 0;
        if (redelivered) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
        this._exchange = exchange;
        this._routingKey = routingKey;
        this._messageCount = messageCount;
    }

    @Override
    public int getClazz() {
        return 60;
    }

    @Override
    public int getMethod() {
        return 71;
    }

    public final long getDeliveryTag() {
        return this._deliveryTag;
    }

    public final boolean getRedelivered() {
        return (this._bitfield0 & 1) != 0;
    }

    public final AMQShortString getExchange() {
        return this._exchange;
    }

    public final AMQShortString getRoutingKey() {
        return this._routingKey;
    }

    public final long getMessageCount() {
        return this._messageCount;
    }

    @Override
    protected int getBodySize() {
        int size = 13;
        size += this.getSizeOf(this._exchange);
        return size += this.getSizeOf(this._routingKey);
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeLong(buffer, this._deliveryTag);
        this.writeBitfield(buffer, this._bitfield0);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._routingKey);
        this.writeUnsignedInteger(buffer, this._messageCount);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchBasicGetOk(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicGetOkBodyImpl: ");
        buf.append("deliveryTag=");
        buf.append(this.getDeliveryTag());
        buf.append(", ");
        buf.append("redelivered=");
        buf.append(this.getRedelivered());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("routingKey=");
        buf.append(this.getRoutingKey());
        buf.append(", ");
        buf.append("messageCount=");
        buf.append(this.getMessageCount());
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer buffer, ClientChannelMethodProcessor dispatcher) {
        long deliveryTag = buffer.getLong();
        boolean redelivered = (buffer.get() & 1) != 0;
        AMQShortString exchange = AMQShortString.readAMQShortString(buffer);
        AMQShortString routingKey = AMQShortString.readAMQShortString(buffer);
        long messageCount = buffer.getUnsignedInt();
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveBasicGetOk(deliveryTag, redelivered, exchange, routingKey, messageCount);
        }
    }
}

