/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiPerfInspectorBandwidthArgs;
import com.cloudera.api.swagger.model.ApiPerfInspectorPingArgs;
import com.cloudera.api.swagger.model.PerfInspectorPolicyType;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Arguments used for the Cloudera Manager level performance inspector. Network diagnostics will be run from every host in sourceCluster to every host in targetCluster.")
public class ApiClustersPerfInspectorArgs {
    @SerializedName(value="sourceCluster")
    private String sourceCluster = null;
    @SerializedName(value="targetCluster")
    private String targetCluster = null;
    @SerializedName(value="pingArgs")
    private ApiPerfInspectorPingArgs pingArgs = null;
    @SerializedName(value="bandwidthArgs")
    private ApiPerfInspectorBandwidthArgs bandwidthArgs = null;
    @SerializedName(value="policyType")
    private PerfInspectorPolicyType policyType = null;

    public ApiClustersPerfInspectorArgs sourceCluster(String sourceCluster) {
        this.sourceCluster = sourceCluster;
        return this;
    }

    @Schema(description="Required name of the source cluster to run network diagnostics test.")
    public String getSourceCluster() {
        return this.sourceCluster;
    }

    public void setSourceCluster(String sourceCluster) {
        this.sourceCluster = sourceCluster;
    }

    public ApiClustersPerfInspectorArgs targetCluster(String targetCluster) {
        this.targetCluster = targetCluster;
        return this;
    }

    @Schema(description="Required name of the target cluster to run network diagnostics test.")
    public String getTargetCluster() {
        return this.targetCluster;
    }

    public void setTargetCluster(String targetCluster) {
        this.targetCluster = targetCluster;
    }

    public ApiClustersPerfInspectorArgs pingArgs(ApiPerfInspectorPingArgs pingArgs) {
        this.pingArgs = pingArgs;
        return this;
    }

    @Schema(description="")
    public ApiPerfInspectorPingArgs getPingArgs() {
        return this.pingArgs;
    }

    public void setPingArgs(ApiPerfInspectorPingArgs pingArgs) {
        this.pingArgs = pingArgs;
    }

    public ApiClustersPerfInspectorArgs bandwidthArgs(ApiPerfInspectorBandwidthArgs bandwidthArgs) {
        this.bandwidthArgs = bandwidthArgs;
        return this;
    }

    @Schema(description="")
    public ApiPerfInspectorBandwidthArgs getBandwidthArgs() {
        return this.bandwidthArgs;
    }

    public void setBandwidthArgs(ApiPerfInspectorBandwidthArgs bandwidthArgs) {
        this.bandwidthArgs = bandwidthArgs;
    }

    public ApiClustersPerfInspectorArgs policyType(PerfInspectorPolicyType policyType) {
        this.policyType = policyType;
        return this;
    }

    @Schema(description="")
    public PerfInspectorPolicyType getPolicyType() {
        return this.policyType;
    }

    public void setPolicyType(PerfInspectorPolicyType policyType) {
        this.policyType = policyType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiClustersPerfInspectorArgs apiClustersPerfInspectorArgs = (ApiClustersPerfInspectorArgs)o;
        return Objects.equals(this.sourceCluster, apiClustersPerfInspectorArgs.sourceCluster) && Objects.equals(this.targetCluster, apiClustersPerfInspectorArgs.targetCluster) && Objects.equals(this.pingArgs, apiClustersPerfInspectorArgs.pingArgs) && Objects.equals(this.bandwidthArgs, apiClustersPerfInspectorArgs.bandwidthArgs) && Objects.equals((Object)this.policyType, (Object)apiClustersPerfInspectorArgs.policyType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceCluster, this.targetCluster, this.pingArgs, this.bandwidthArgs, this.policyType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiClustersPerfInspectorArgs {\n");
        sb.append("    sourceCluster: ").append(this.toIndentedString(this.sourceCluster)).append("\n");
        sb.append("    targetCluster: ").append(this.toIndentedString(this.targetCluster)).append("\n");
        sb.append("    pingArgs: ").append(this.toIndentedString(this.pingArgs)).append("\n");
        sb.append("    bandwidthArgs: ").append(this.toIndentedString(this.bandwidthArgs)).append("\n");
        sb.append("    policyType: ").append(this.toIndentedString((Object)this.policyType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

