/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.filter.authz;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.lang.util.StringUtils;
import org.apache.shiro.web.filter.authz.AuthorizationFilter;
import org.apache.shiro.web.util.WebUtils;

public class PortFilter
extends AuthorizationFilter {
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final String HTTP_SCHEME = "http";
    private int port = 80;

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    protected int toPort(Object mappedValue) {
        Object[] ports = (String[])mappedValue;
        if (ports == null || ports.length == 0) {
            return this.getPort();
        }
        if (ports.length > 1) {
            throw new ConfigurationException("PortFilter can only be configured with a single port.  You have configured " + ports.length + ": " + StringUtils.toString(ports));
        }
        return Integer.parseInt(ports[0]);
    }

    @Override
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        int requestPort;
        int requiredPort = this.toPort(mappedValue);
        return requiredPort == (requestPort = request.getServerPort());
    }

    protected String getScheme(String requestScheme, int port) {
        if (port == 80) {
            return HTTP_SCHEME;
        }
        if (port == 443) {
            return "https";
        }
        return requestScheme;
    }

    @Override
    protected boolean onAccessDenied(ServletRequest request, ServletResponse response, Object mappedValue) throws IOException {
        int port = this.toPort(mappedValue);
        String scheme = this.getScheme(request.getScheme(), port);
        StringBuilder sb = new StringBuilder();
        sb.append(scheme).append("://");
        sb.append(request.getServerName());
        if (port != 80 && port != 443) {
            sb.append(":");
            sb.append(port);
        }
        if (request instanceof HttpServletRequest) {
            sb.append(WebUtils.toHttp(request).getRequestURI());
            String query2 = WebUtils.toHttp(request).getQueryString();
            if (query2 != null) {
                sb.append("?").append(query2);
            }
        }
        WebUtils.issueRedirect(request, response, sb.toString());
        return false;
    }
}

