/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.ShaclParseException;
import org.apache.jena.shacl.sys.C;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.path.P_Alt;
import org.apache.jena.sparql.path.P_Distinct;
import org.apache.jena.sparql.path.P_FixedLength;
import org.apache.jena.sparql.path.P_Inverse;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Mod;
import org.apache.jena.sparql.path.P_Multi;
import org.apache.jena.sparql.path.P_NegPropSet;
import org.apache.jena.sparql.path.P_OneOrMore1;
import org.apache.jena.sparql.path.P_OneOrMoreN;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.P_Seq;
import org.apache.jena.sparql.path.P_Shortest;
import org.apache.jena.sparql.path.P_ZeroOrMore1;
import org.apache.jena.sparql.path.P_ZeroOrMoreN;
import org.apache.jena.sparql.path.P_ZeroOrOne;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathFactory;
import org.apache.jena.sparql.path.PathVisitor;
import org.apache.jena.sparql.path.PathWriter;
import org.apache.jena.sparql.path.eval.PathEval;
import org.apache.jena.system.G;

public class ShaclPaths {
    public static Set<Node> valueNodes(Graph graph, Node node, Path path) {
        if (path instanceof P_Link) {
            P_Link plink = (P_Link)path;
            Node p = plink.getNode();
            return G.allSP(graph, node, p);
        }
        return Iter.toSet(ShaclPaths.pathReachIter(graph, node, path));
    }

    private static Iterator<Node> pathReachIter(Graph graph, Node node, Path path) {
        if (path instanceof P_Link) {
            P_Link pLink = (P_Link)path;
            Node p = pLink.getNode();
            return G.iterSP(graph, node, p);
        }
        return PathEval.eval(graph, node, path, null);
    }

    private static void toRDF(Graph graph, Node node, Path path) {
        throw new NotImplemented();
    }

    public static Path parsePath(Graph graph, Node node) {
        return ShaclPaths.path(graph, node);
    }

    private static Path path(Graph graph, Node node) {
        if (node.isURI() && !C.NIL.equals(node)) {
            return PathFactory.pathLink(node);
        }
        if (ShaclPaths.isList(graph, node)) {
            List<Node> nodes = G.rdfList(graph, node);
            if (nodes.isEmpty()) {
                throw new ShaclParseException("Empty list for path sequence");
            }
            Path path = null;
            for (Node n : nodes) {
                Path p = ShaclPaths.path(graph, n);
                if (path == null) {
                    path = p;
                    continue;
                }
                path = PathFactory.pathSeq(path, p);
            }
            return path;
        }
        if (node.isBlank()) {
            if (G.hasProperty(graph, node, SHACL.inversePath)) {
                Node x = G.getSP(graph, node, SHACL.inversePath);
                Path p = ShaclPaths.path(graph, x);
                return PathFactory.pathInverse(p);
            }
            if (G.hasProperty(graph, node, SHACL.zeroOrMorePath)) {
                Node x = G.getSP(graph, node, SHACL.zeroOrMorePath);
                Path p = ShaclPaths.path(graph, x);
                return PathFactory.pathZeroOrMore1(p);
            }
            if (G.hasProperty(graph, node, SHACL.oneOrMorePath)) {
                Node x = G.getSP(graph, node, SHACL.oneOrMorePath);
                Path p = ShaclPaths.path(graph, x);
                return PathFactory.pathOneOrMore1(p);
            }
            if (G.hasProperty(graph, node, SHACL.zeroOrOnePath)) {
                Node x = G.getSP(graph, node, SHACL.zeroOrOnePath);
                Path p = ShaclPaths.path(graph, x);
                return PathFactory.pathZeroOrOne(p);
            }
            if (G.hasProperty(graph, node, SHACL.alternativePath)) {
                Node x = G.getSP(graph, node, SHACL.alternativePath);
                if (!ShaclPaths.isList(graph, x)) {
                    throw new ShaclParseException("Not a list for path alternativePath");
                }
                List<Node> nodes = G.rdfList(graph, x);
                Path path = null;
                for (Node n : nodes) {
                    Path p = ShaclPaths.path(graph, n);
                    if (path == null) {
                        path = p;
                        continue;
                    }
                    path = PathFactory.pathAlt(path, p);
                }
                return path;
            }
        }
        throw new ShaclParseException("Bad list: " + ShLib.displayStr(node));
    }

    private static boolean isList(Graph graph, Node node) {
        return C.NIL.equals(node) || G.contains(graph, node, C.FIRST, null);
    }

    public static Node copyPath(Graph srcGraph, Graph dstGraph, Node start) {
        Path resultPath = ShaclPaths.parsePath(srcGraph, start);
        Node pn = ShaclPaths.pathToRDF(resultPath, dstGraph);
        return pn;
    }

    public static String pathToString(Path path) {
        return PathWriter.asString(path);
    }

    public static String pathToString(Graph graph, Path path) {
        Prologue prologue = new Prologue(graph.getPrefixMapping());
        return PathWriter.asString(path, prologue);
    }

    public static void write(IndentedWriter out, Path path, Prologue prologue) {
        PathWriter.write(out, path, prologue);
    }

    public static void write(IndentedWriter out, Path path, NodeFormatter nodeFmt) {
        Node n = ShaclPaths.pathNode(path);
        if (n == null) {
            out.print(PathWriter.asString(path));
        } else {
            nodeFmt.format(out, n);
        }
    }

    public static Node pathNode(Path path) {
        if (path instanceof P_Link) {
            P_Link pLink = (P_Link)path;
            return pLink.getNode();
        }
        return null;
    }

    public static Node pathToRDF(Path p, Graph dstGraph) {
        Node n = ShaclPaths.pathToRDF(dstGraph::add, p);
        return n;
    }

    public static Node pathToRDF(Path p, StreamRDF dest) {
        Node n = ShaclPaths.pathToRDF(dest::triple, p);
        return n;
    }

    public static Node pathToRDF(Consumer<Triple> acc, Path p) {
        PathToRDF proc = new PathToRDF(acc);
        p.visit(proc);
        return proc.point;
    }

    static class PathToRDF
    implements PathVisitor {
        private final Consumer<Triple> acc;
        private Node point;

        PathToRDF(Consumer<Triple> acc) {
            this.acc = acc;
        }

        private Node pathToRDF$(Path p) {
            p.visit(this);
            return this.point;
        }

        @Override
        public void visit(P_Link pathNode) {
            this.point = pathNode.getNode();
        }

        @Override
        public void visit(P_ReverseLink pathNode) {
            Node n = pathNode.getNode();
            this.point = NodeFactory.createBlankNode();
            Triple t = Triple.create(this.point, SHACL.alternativePath, n);
            this.acc.accept(t);
        }

        @Override
        public void visit(P_Alt pathAlt) {
            Node n1 = this.pathToRDF$(pathAlt.getLeft());
            Node n2 = this.pathToRDF$(pathAlt.getRight());
            Node list = PathToRDF.list(this.acc, n1, n2);
            this.point = NodeFactory.createBlankNode();
            Triple t = Triple.create(this.point, SHACL.alternativePath, list);
            this.acc.accept(t);
        }

        private static Node list(Consumer<Triple> acc, Node ... elts) {
            Node list = C.NIL;
            for (int i = elts.length - 1; i >= 0; --i) {
                Node elt = elts[i];
                Node cell = NodeFactory.createBlankNode();
                Triple t1 = Triple.create(cell, C.REST, list);
                Triple t2 = Triple.create(cell, C.FIRST, elt);
                acc.accept(t1);
                acc.accept(t2);
                list = cell;
            }
            return list;
        }

        @Override
        public void visit(P_Seq pathSeq) {
            Node list;
            Node n1 = this.pathToRDF$(pathSeq.getLeft());
            Node n2 = this.pathToRDF$(pathSeq.getRight());
            this.point = list = PathToRDF.list(this.acc, n1, n2);
        }

        private Node step(Node predicate, Path path) {
            Node p = this.pathToRDF$(path);
            Node n = NodeFactory.createBlankNode();
            Triple t = Triple.create(n, predicate, p);
            this.acc.accept(t);
            return n;
        }

        @Override
        public void visit(P_OneOrMore1 path) {
            this.point = this.step(SHACL.oneOrMorePath, path.getSubPath());
        }

        @Override
        public void visit(P_ZeroOrOne path) {
            this.point = this.step(SHACL.zeroOrOnePath, path.getSubPath());
        }

        @Override
        public void visit(P_ZeroOrMore1 path) {
            this.point = this.step(SHACL.zeroOrMorePath, path.getSubPath());
        }

        @Override
        public void visit(P_OneOrMoreN path) {
            throw new ShaclParseException("Not part of SHACL: " + String.valueOf(path));
        }

        @Override
        public void visit(P_ZeroOrMoreN path) {
            throw new ShaclParseException("Not part of SHACL: " + String.valueOf(path));
        }

        @Override
        public void visit(P_Inverse inversePath) {
            this.point = this.step(SHACL.inversePath, inversePath.getSubPath());
        }

        @Override
        public void visit(P_Shortest pathShortest) {
            throw new ShaclParseException("Not part of SHACL: " + String.valueOf(pathShortest));
        }

        @Override
        public void visit(P_Multi pathMulti) {
            throw new ShaclParseException("Not part of SHACL: " + String.valueOf(pathMulti));
        }

        @Override
        public void visit(P_Distinct pathDistinct) {
            throw new ShaclParseException("Not part of SHACL: " + String.valueOf(pathDistinct));
        }

        @Override
        public void visit(P_FixedLength pFixedLength) {
            throw new ShaclParseException("Not part of SHACL: " + String.valueOf(pFixedLength));
        }

        @Override
        public void visit(P_Mod pathMod) {
            throw new ShaclParseException("Not part of SHACL: " + String.valueOf(pathMod));
        }

        @Override
        public void visit(P_NegPropSet pathNotOneOf) {
            throw new ShaclParseException("Not part of SHACL: " + String.valueOf(pathNotOneOf));
        }
    }
}

