/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ext.xerces.jaxp.datatype;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.jena.ext.xerces.jaxp.datatype.DurationImpl;
import org.apache.jena.ext.xerces.util.DatatypeMessageFormatter;

class XMLGregorianCalendarImpl
extends XMLGregorianCalendar
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3905403108073447394L;
    private BigInteger orig_eon;
    private int orig_year = Integer.MIN_VALUE;
    private int orig_month = Integer.MIN_VALUE;
    private int orig_day = Integer.MIN_VALUE;
    private int orig_hour = Integer.MIN_VALUE;
    private int orig_minute = Integer.MIN_VALUE;
    private int orig_second = Integer.MIN_VALUE;
    private BigDecimal orig_fracSeconds;
    private int orig_timezone = Integer.MIN_VALUE;
    private BigInteger eon = null;
    private int year = Integer.MIN_VALUE;
    private int month = Integer.MIN_VALUE;
    private int day = Integer.MIN_VALUE;
    private int timezone = Integer.MIN_VALUE;
    private int hour = Integer.MIN_VALUE;
    private int minute = Integer.MIN_VALUE;
    private int second = Integer.MIN_VALUE;
    private BigDecimal fractionalSecond = null;
    private static final BigInteger BILLION_B = BigInteger.valueOf(1000000000L);
    private static final int BILLION_I = 1000000000;
    private static final Date PURE_GREGORIAN_CHANGE = new Date(Long.MIN_VALUE);
    private static final int YEAR = 0;
    private static final int MONTH = 1;
    private static final int DAY = 2;
    private static final int HOUR = 3;
    private static final int MINUTE = 4;
    private static final int SECOND = 5;
    private static final int MILLISECOND = 6;
    private static final int TIMEZONE = 7;
    private static final int[] MIN_FIELD_VALUE = new int[]{Integer.MIN_VALUE, 1, 1, 0, 0, 0, 0, -840};
    private static final int[] MAX_FIELD_VALUE = new int[]{Integer.MAX_VALUE, 12, 31, 24, 59, 60, 999, 840};
    private static final String[] FIELD_NAME = new String[]{"Year", "Month", "Day", "Hour", "Minute", "Second", "Millisecond", "Timezone"};
    private static final BigInteger FOUR = BigInteger.valueOf(4L);
    private static final BigInteger HUNDRED = BigInteger.valueOf(100L);
    private static final BigInteger FOUR_HUNDRED = BigInteger.valueOf(400L);
    private static final BigInteger SIXTY = BigInteger.valueOf(60L);
    private static final BigInteger TWENTY_FOUR = BigInteger.valueOf(24L);
    private static final BigInteger TWELVE = BigInteger.valueOf(12L);
    private static final BigDecimal DECIMAL_ZERO = BigDecimal.valueOf(0L);
    private static final BigDecimal DECIMAL_ONE = BigDecimal.valueOf(1L);
    private static final BigDecimal DECIMAL_SIXTY = BigDecimal.valueOf(60L);

    protected XMLGregorianCalendarImpl(String lexicalRepresentation) throws IllegalArgumentException {
        String format = null;
        String lexRep = lexicalRepresentation;
        int NOT_FOUND = -1;
        int lexRepLength = lexRep.length();
        if (lexRep.indexOf(84) != -1) {
            format = "%Y-%M-%DT%h:%m:%s%z";
        } else if (lexRepLength >= 3 && lexRep.charAt(2) == ':') {
            format = "%h:%m:%s%z";
        } else if (lexRep.startsWith("--")) {
            if (lexRepLength >= 3 && lexRep.charAt(2) == '-') {
                format = "---%D%z";
            } else if (lexRepLength == 4 || lexRepLength >= 6 && (lexRep.charAt(4) == '+' || lexRep.charAt(4) == '-' && (lexRep.charAt(5) == '-' || lexRepLength == 10))) {
                format = "--%M--%z";
                Parser p = new Parser(format, lexRep);
                try {
                    p.parse();
                    if (!this.isValid()) {
                        throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidXGCRepresentation", new Object[]{lexicalRepresentation}));
                    }
                    this.save();
                    return;
                }
                catch (IllegalArgumentException e2) {
                    format = "--%M%z";
                }
            } else {
                format = "--%M-%D%z";
            }
        } else {
            int countSeparator = 0;
            int timezoneOffset = lexRep.indexOf(58);
            if (timezoneOffset != -1) {
                lexRepLength -= 6;
            }
            for (int i = 1; i < lexRepLength; ++i) {
                if (lexRep.charAt(i) != '-') continue;
                ++countSeparator;
            }
            format = countSeparator == 0 ? "%Y%z" : (countSeparator == 1 ? "%Y-%M%z" : "%Y-%M-%D%z");
        }
        Parser p = new Parser(format, lexRep);
        p.parse();
        if (!this.isValid()) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidXGCRepresentation", new Object[]{lexicalRepresentation}));
        }
        this.save();
    }

    private void save() {
        this.orig_eon = this.eon;
        this.orig_year = this.year;
        this.orig_month = this.month;
        this.orig_day = this.day;
        this.orig_hour = this.hour;
        this.orig_minute = this.minute;
        this.orig_second = this.second;
        this.orig_fracSeconds = this.fractionalSecond;
        this.orig_timezone = this.timezone;
    }

    public XMLGregorianCalendarImpl() {
    }

    protected XMLGregorianCalendarImpl(BigInteger year, int month, int day, int hour, int minute, int second, BigDecimal fractionalSecond, int timezone2) {
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
        this.setTime(hour, minute, second, fractionalSecond);
        this.setTimezone(timezone2);
        if (!this.isValid()) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidXGCValue-fractional", new Object[]{year, month, day, hour, minute, second, fractionalSecond, timezone2}));
        }
        this.save();
    }

    private XMLGregorianCalendarImpl(int year, int month, int day, int hour, int minute, int second, int millisecond, int timezone2) {
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
        this.setTime(hour, minute, second);
        this.setTimezone(timezone2);
        BigDecimal realMilliseconds = null;
        if (millisecond != Integer.MIN_VALUE) {
            realMilliseconds = BigDecimal.valueOf(millisecond, 3);
        }
        this.setFractionalSecond(realMilliseconds);
        if (!this.isValid()) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidXGCValue-milli", new Object[]{year, month, day, hour, minute, second, millisecond, timezone2}));
        }
        this.save();
    }

    public XMLGregorianCalendarImpl(GregorianCalendar cal) {
        int year = cal.get(1);
        if (cal.get(0) == 0) {
            year = -year;
        }
        this.setYear(year);
        this.setMonth(cal.get(2) + 1);
        this.setDay(cal.get(5));
        this.setTime(cal.get(11), cal.get(12), cal.get(13), cal.get(14));
        int offsetInMinutes = (cal.get(15) + cal.get(16)) / 60000;
        this.setTimezone(offsetInMinutes);
        this.save();
    }

    public static XMLGregorianCalendar createDateTime(int year, int month, int day, int hours, int minutes, int seconds, int milliseconds, int timezone2) {
        return new XMLGregorianCalendarImpl(year, month, day, hours, minutes, seconds, milliseconds, timezone2);
    }

    @Override
    public BigInteger getEon() {
        return this.eon;
    }

    @Override
    public int getYear() {
        return this.year;
    }

    @Override
    public BigInteger getEonAndYear() {
        if (this.year != Integer.MIN_VALUE && this.eon != null) {
            return this.eon.add(BigInteger.valueOf(this.year));
        }
        if (this.year != Integer.MIN_VALUE && this.eon == null) {
            return BigInteger.valueOf(this.year);
        }
        return null;
    }

    @Override
    public int getMonth() {
        return this.month;
    }

    @Override
    public int getDay() {
        return this.day;
    }

    @Override
    public int getTimezone() {
        return this.timezone;
    }

    @Override
    public int getHour() {
        return this.hour;
    }

    @Override
    public int getMinute() {
        return this.minute;
    }

    @Override
    public int getSecond() {
        return this.second;
    }

    private BigDecimal getSeconds() {
        if (this.second == Integer.MIN_VALUE) {
            return DECIMAL_ZERO;
        }
        BigDecimal result = BigDecimal.valueOf(this.second);
        if (this.fractionalSecond != null) {
            return result.add(this.fractionalSecond);
        }
        return result;
    }

    @Override
    public int getMillisecond() {
        if (this.fractionalSecond == null) {
            return Integer.MIN_VALUE;
        }
        return this.fractionalSecond.movePointRight(3).intValue();
    }

    @Override
    public BigDecimal getFractionalSecond() {
        return this.fractionalSecond;
    }

    @Override
    public void setYear(BigInteger year) {
        if (year == null) {
            this.eon = null;
            this.year = Integer.MIN_VALUE;
        } else {
            BigInteger temp = year.remainder(BILLION_B);
            this.year = temp.intValue();
            this.setEon(year.subtract(temp));
        }
    }

    @Override
    public void setYear(int year) {
        if (year == Integer.MIN_VALUE) {
            this.year = Integer.MIN_VALUE;
            this.eon = null;
        } else if (Math.abs(year) < 1000000000) {
            this.year = year;
            this.eon = null;
        } else {
            BigInteger theYear = BigInteger.valueOf(year);
            BigInteger remainder = theYear.remainder(BILLION_B);
            this.year = remainder.intValue();
            this.setEon(theYear.subtract(remainder));
        }
    }

    private void setEon(BigInteger eon) {
        this.eon = eon != null && eon.compareTo(BigInteger.ZERO) == 0 ? null : eon;
    }

    @Override
    public void setMonth(int month) {
        this.checkFieldValueConstraint(1, month);
        this.month = month;
    }

    @Override
    public void setDay(int day) {
        this.checkFieldValueConstraint(2, day);
        this.day = day;
    }

    @Override
    public void setTimezone(int offset) {
        this.checkFieldValueConstraint(7, offset);
        this.timezone = offset;
    }

    @Override
    public void setTime(int hour, int minute, int second) {
        this.setTime(hour, minute, second, null);
    }

    private void checkFieldValueConstraint(int field, int value) throws IllegalArgumentException {
        if (value < MIN_FIELD_VALUE[field] && value != Integer.MIN_VALUE || value > MAX_FIELD_VALUE[field]) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidFieldValue", new Object[]{value, FIELD_NAME[field]}));
        }
    }

    @Override
    public void setHour(int hour) {
        this.checkFieldValueConstraint(3, hour);
        this.hour = hour;
    }

    @Override
    public void setMinute(int minute) {
        this.checkFieldValueConstraint(4, minute);
        this.minute = minute;
    }

    @Override
    public void setSecond(int second) {
        this.checkFieldValueConstraint(5, second);
        this.second = second;
    }

    @Override
    public void setTime(int hour, int minute, int second, BigDecimal fractional) {
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(second);
        this.setFractionalSecond(fractional);
    }

    @Override
    public void setTime(int hour, int minute, int second, int millisecond) {
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(second);
        this.setMillisecond(millisecond);
    }

    @Override
    public int compare(XMLGregorianCalendar rhs) {
        XMLGregorianCalendar MaxP;
        int result = 2;
        XMLGregorianCalendar P = this;
        XMLGregorianCalendar Q = rhs;
        if (P.getTimezone() == Q.getTimezone()) {
            return XMLGregorianCalendarImpl.internalCompare(P, Q);
        }
        if (P.getTimezone() != Integer.MIN_VALUE && Q.getTimezone() != Integer.MIN_VALUE) {
            P = P.normalize();
            Q = Q.normalize();
            return XMLGregorianCalendarImpl.internalCompare(P, Q);
        }
        if (P.getTimezone() != Integer.MIN_VALUE) {
            XMLGregorianCalendar MinQ;
            if (P.getTimezone() != 0) {
                P = P.normalize();
            }
            if ((result = XMLGregorianCalendarImpl.internalCompare(P, MinQ = this.normalizeToTimezone(Q, 840))) == -1) {
                return result;
            }
            XMLGregorianCalendar MaxQ = this.normalizeToTimezone(Q, -840);
            result = XMLGregorianCalendarImpl.internalCompare(P, MaxQ);
            if (result == 1) {
                return result;
            }
            return 2;
        }
        if (Q.getTimezone() != 0) {
            Q = this.normalizeToTimezone(Q, Q.getTimezone());
        }
        if ((result = XMLGregorianCalendarImpl.internalCompare(MaxP = this.normalizeToTimezone(P, -840), Q)) == -1) {
            return result;
        }
        XMLGregorianCalendar MinP = this.normalizeToTimezone(P, 840);
        result = XMLGregorianCalendarImpl.internalCompare(MinP, Q);
        if (result == 1) {
            return result;
        }
        return 2;
    }

    @Override
    public XMLGregorianCalendar normalize() {
        XMLGregorianCalendar normalized = this.normalizeToTimezone(this, this.timezone);
        if (this.getTimezone() == Integer.MIN_VALUE) {
            normalized.setTimezone(Integer.MIN_VALUE);
        }
        if (this.getMillisecond() == Integer.MIN_VALUE) {
            normalized.setMillisecond(Integer.MIN_VALUE);
        }
        return normalized;
    }

    private XMLGregorianCalendar normalizeToTimezone(XMLGregorianCalendar cal, int timezone2) {
        int minutes = timezone2;
        XMLGregorianCalendar result = (XMLGregorianCalendar)cal.clone();
        DurationImpl d = new DurationImpl((minutes = -minutes) >= 0, 0, 0, 0, 0, minutes < 0 ? -minutes : minutes, 0);
        result.add(d);
        result.setTimezone(0);
        return result;
    }

    private static int internalCompare(XMLGregorianCalendar P, XMLGregorianCalendar Q) {
        int result;
        if (P.getEon() == Q.getEon() ? (result = XMLGregorianCalendarImpl.compareField(P.getYear(), Q.getYear())) != 0 : (result = XMLGregorianCalendarImpl.compareField(P.getEonAndYear(), Q.getEonAndYear())) != 0) {
            return result;
        }
        result = XMLGregorianCalendarImpl.compareField(P.getMonth(), Q.getMonth());
        if (result != 0) {
            return result;
        }
        result = XMLGregorianCalendarImpl.compareField(P.getDay(), Q.getDay());
        if (result != 0) {
            return result;
        }
        result = XMLGregorianCalendarImpl.compareField(P.getHour(), Q.getHour());
        if (result != 0) {
            return result;
        }
        result = XMLGregorianCalendarImpl.compareField(P.getMinute(), Q.getMinute());
        if (result != 0) {
            return result;
        }
        result = XMLGregorianCalendarImpl.compareField(P.getSecond(), Q.getSecond());
        if (result != 0) {
            return result;
        }
        result = XMLGregorianCalendarImpl.compareField(P.getFractionalSecond(), Q.getFractionalSecond());
        return result;
    }

    private static int compareField(int Pfield, int Qfield) {
        if (Pfield == Qfield) {
            return 0;
        }
        if (Pfield == Integer.MIN_VALUE || Qfield == Integer.MIN_VALUE) {
            return 2;
        }
        return Pfield < Qfield ? -1 : 1;
    }

    private static int compareField(BigInteger Pfield, BigInteger Qfield) {
        if (Pfield == null) {
            return Qfield == null ? 0 : 2;
        }
        if (Qfield == null) {
            return 2;
        }
        return Pfield.compareTo(Qfield);
    }

    private static int compareField(BigDecimal Pfield, BigDecimal Qfield) {
        if (Pfield == Qfield) {
            return 0;
        }
        if (Pfield == null) {
            Pfield = DECIMAL_ZERO;
        }
        if (Qfield == null) {
            Qfield = DECIMAL_ZERO;
        }
        return Pfield.compareTo(Qfield);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof XMLGregorianCalendar) {
            return this.compare((XMLGregorianCalendar)obj) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int timezone2 = this.getTimezone();
        if (timezone2 == Integer.MIN_VALUE) {
            timezone2 = 0;
        }
        XMLGregorianCalendar gc = this;
        if (timezone2 != 0) {
            gc = this.normalizeToTimezone(this, this.getTimezone());
        }
        return gc.getYear() + gc.getMonth() + gc.getDay() + gc.getHour() + gc.getMinute() + gc.getSecond();
    }

    public static XMLGregorianCalendar parse(String lexicalRepresentation) {
        return new XMLGregorianCalendarImpl(lexicalRepresentation);
    }

    @Override
    public String toXMLFormat() {
        QName typekind = this.getXMLSchemaType();
        String formatString = null;
        if (typekind == DatatypeConstants.DATETIME) {
            formatString = "%Y-%M-%DT%h:%m:%s%z";
        } else if (typekind == DatatypeConstants.DATE) {
            formatString = "%Y-%M-%D%z";
        } else if (typekind == DatatypeConstants.TIME) {
            formatString = "%h:%m:%s%z";
        } else if (typekind == DatatypeConstants.GMONTH) {
            formatString = "--%M--%z";
        } else if (typekind == DatatypeConstants.GDAY) {
            formatString = "---%D%z";
        } else if (typekind == DatatypeConstants.GYEAR) {
            formatString = "%Y%z";
        } else if (typekind == DatatypeConstants.GYEARMONTH) {
            formatString = "%Y-%M%z";
        } else if (typekind == DatatypeConstants.GMONTHDAY) {
            formatString = "--%M-%D%z";
        }
        return this.format(formatString);
    }

    @Override
    public QName getXMLSchemaType() {
        if (this.year != Integer.MIN_VALUE && this.month != Integer.MIN_VALUE && this.day != Integer.MIN_VALUE && this.hour != Integer.MIN_VALUE && this.minute != Integer.MIN_VALUE && this.second != Integer.MIN_VALUE) {
            return DatatypeConstants.DATETIME;
        }
        if (this.year != Integer.MIN_VALUE && this.month != Integer.MIN_VALUE && this.day != Integer.MIN_VALUE && this.hour == Integer.MIN_VALUE && this.minute == Integer.MIN_VALUE && this.second == Integer.MIN_VALUE) {
            return DatatypeConstants.DATE;
        }
        if (this.year == Integer.MIN_VALUE && this.month == Integer.MIN_VALUE && this.day == Integer.MIN_VALUE && this.hour != Integer.MIN_VALUE && this.minute != Integer.MIN_VALUE && this.second != Integer.MIN_VALUE) {
            return DatatypeConstants.TIME;
        }
        if (this.year != Integer.MIN_VALUE && this.month != Integer.MIN_VALUE && this.day == Integer.MIN_VALUE && this.hour == Integer.MIN_VALUE && this.minute == Integer.MIN_VALUE && this.second == Integer.MIN_VALUE) {
            return DatatypeConstants.GYEARMONTH;
        }
        if (this.year == Integer.MIN_VALUE && this.month != Integer.MIN_VALUE && this.day != Integer.MIN_VALUE && this.hour == Integer.MIN_VALUE && this.minute == Integer.MIN_VALUE && this.second == Integer.MIN_VALUE) {
            return DatatypeConstants.GMONTHDAY;
        }
        if (this.year != Integer.MIN_VALUE && this.month == Integer.MIN_VALUE && this.day == Integer.MIN_VALUE && this.hour == Integer.MIN_VALUE && this.minute == Integer.MIN_VALUE && this.second == Integer.MIN_VALUE) {
            return DatatypeConstants.GYEAR;
        }
        if (this.year == Integer.MIN_VALUE && this.month != Integer.MIN_VALUE && this.day == Integer.MIN_VALUE && this.hour == Integer.MIN_VALUE && this.minute == Integer.MIN_VALUE && this.second == Integer.MIN_VALUE) {
            return DatatypeConstants.GMONTH;
        }
        if (this.year == Integer.MIN_VALUE && this.month == Integer.MIN_VALUE && this.day != Integer.MIN_VALUE && this.hour == Integer.MIN_VALUE && this.minute == Integer.MIN_VALUE && this.second == Integer.MIN_VALUE) {
            return DatatypeConstants.GDAY;
        }
        throw new IllegalStateException(this.getClass().getName() + "#getXMLSchemaType() :" + DatatypeMessageFormatter.formatMessage(null, "InvalidXGCFields", null));
    }

    @Override
    public boolean isValid() {
        if (this.month != Integer.MIN_VALUE && this.day != Integer.MIN_VALUE && (this.year != Integer.MIN_VALUE ? (this.eon == null ? this.day > XMLGregorianCalendarImpl.maximumDayInMonthFor(this.year, this.month) : this.day > XMLGregorianCalendarImpl.maximumDayInMonthFor(this.getEonAndYear(), this.month)) : this.day > XMLGregorianCalendarImpl.maximumDayInMonthFor(2000, this.month))) {
            return false;
        }
        return this.hour != 24 || this.minute == 0 && this.second == 0 && (this.fractionalSecond == null || this.fractionalSecond.compareTo(DECIMAL_ZERO) == 0);
    }

    @Override
    public void add(Duration duration) {
        BigDecimal startSeconds;
        boolean[] fieldUndefined = new boolean[]{false, false, false, false, false, false};
        int signum = duration.getSign();
        int startMonth = this.getMonth();
        if (startMonth == Integer.MIN_VALUE) {
            startMonth = MIN_FIELD_VALUE[1];
            fieldUndefined[1] = true;
        }
        BigInteger dMonths = XMLGregorianCalendarImpl.sanitize(duration.getField(DatatypeConstants.MONTHS), signum);
        BigInteger temp = BigInteger.valueOf(startMonth).add(dMonths);
        this.setMonth(temp.subtract(BigInteger.ONE).mod(TWELVE).intValue() + 1);
        BigInteger carry = new BigDecimal(temp.subtract(BigInteger.ONE)).divide(new BigDecimal(TWELVE), RoundingMode.FLOOR).toBigInteger();
        BigInteger startYear = this.getEonAndYear();
        if (startYear == null) {
            fieldUndefined[0] = true;
            startYear = BigInteger.ZERO;
        }
        BigInteger dYears = XMLGregorianCalendarImpl.sanitize(duration.getField(DatatypeConstants.YEARS), signum);
        BigInteger endYear = startYear.add(dYears).add(carry);
        this.setYear(endYear);
        if (this.getSecond() == Integer.MIN_VALUE) {
            fieldUndefined[5] = true;
            startSeconds = DECIMAL_ZERO;
        } else {
            startSeconds = this.getSeconds();
        }
        BigDecimal dSeconds = DurationImpl.sanitize((BigDecimal)duration.getField(DatatypeConstants.SECONDS), signum);
        BigDecimal tempBD = startSeconds.add(dSeconds);
        BigDecimal fQuotient = new BigDecimal(new BigDecimal(tempBD.toBigInteger()).divide(DECIMAL_SIXTY, RoundingMode.FLOOR).toBigInteger());
        BigDecimal endSeconds = tempBD.subtract(fQuotient.multiply(DECIMAL_SIXTY));
        carry = fQuotient.toBigInteger();
        this.setSecond(endSeconds.intValue());
        BigDecimal tempFracSeconds = endSeconds.subtract(new BigDecimal(BigInteger.valueOf(this.getSecond())));
        if (tempFracSeconds.compareTo(DECIMAL_ZERO) < 0) {
            this.setFractionalSecond(DECIMAL_ONE.add(tempFracSeconds));
            if (this.getSecond() == 0) {
                this.setSecond(59);
                carry = carry.subtract(BigInteger.ONE);
            } else {
                this.setSecond(this.getSecond() - 1);
            }
        } else {
            this.setFractionalSecond(tempFracSeconds);
        }
        int startMinutes = this.getMinute();
        if (startMinutes == Integer.MIN_VALUE) {
            fieldUndefined[4] = true;
            startMinutes = MIN_FIELD_VALUE[4];
        }
        BigInteger dMinutes = XMLGregorianCalendarImpl.sanitize(duration.getField(DatatypeConstants.MINUTES), signum);
        temp = BigInteger.valueOf(startMinutes).add(dMinutes).add(carry);
        this.setMinute(temp.mod(SIXTY).intValue());
        carry = new BigDecimal(temp).divide(DECIMAL_SIXTY, RoundingMode.FLOOR).toBigInteger();
        int startHours = this.getHour();
        if (startHours == Integer.MIN_VALUE) {
            fieldUndefined[3] = true;
            startHours = MIN_FIELD_VALUE[3];
        }
        BigInteger dHours = XMLGregorianCalendarImpl.sanitize(duration.getField(DatatypeConstants.HOURS), signum);
        temp = BigInteger.valueOf(startHours).add(dHours).add(carry);
        this.setHour(temp.mod(TWENTY_FOUR).intValue());
        carry = new BigDecimal(temp).divide(new BigDecimal(TWENTY_FOUR), RoundingMode.FLOOR).toBigInteger();
        int startDay = this.getDay();
        if (startDay == Integer.MIN_VALUE) {
            fieldUndefined[2] = true;
            startDay = MIN_FIELD_VALUE[2];
        }
        BigInteger dDays = XMLGregorianCalendarImpl.sanitize(duration.getField(DatatypeConstants.DAYS), signum);
        int maxDayInMonth = XMLGregorianCalendarImpl.maximumDayInMonthFor(this.getEonAndYear(), this.getMonth());
        BigInteger tempDays = startDay > maxDayInMonth ? BigInteger.valueOf(maxDayInMonth) : (startDay < 1 ? BigInteger.ONE : BigInteger.valueOf(startDay));
        BigInteger endDays = tempDays.add(dDays).add(carry);
        while (true) {
            int quotient;
            int monthCarry;
            if (endDays.compareTo(BigInteger.ONE) < 0) {
                BigInteger mdimf = null;
                mdimf = this.month >= 2 ? BigInteger.valueOf(XMLGregorianCalendarImpl.maximumDayInMonthFor(this.getEonAndYear(), this.getMonth() - 1)) : BigInteger.valueOf(XMLGregorianCalendarImpl.maximumDayInMonthFor(this.getEonAndYear().subtract(BigInteger.valueOf(1L)), 12));
                endDays = endDays.add(mdimf);
                monthCarry = -1;
            } else {
                if (endDays.compareTo(BigInteger.valueOf(XMLGregorianCalendarImpl.maximumDayInMonthFor(this.getEonAndYear(), this.getMonth()))) <= 0) break;
                endDays = endDays.add(BigInteger.valueOf(-XMLGregorianCalendarImpl.maximumDayInMonthFor(this.getEonAndYear(), this.getMonth())));
                monthCarry = 1;
            }
            int intTemp = this.getMonth() + monthCarry;
            int endMonth = (intTemp - 1) % 12;
            if (endMonth < 0) {
                endMonth = 12 + endMonth + 1;
                quotient = BigDecimal.valueOf(intTemp - 1).divide(new BigDecimal(TWELVE), RoundingMode.UP).intValue();
            } else {
                quotient = (intTemp - 1) / 12;
                ++endMonth;
            }
            this.setMonth(endMonth);
            if (quotient == 0) continue;
            this.setYear(this.getEonAndYear().add(BigInteger.valueOf(quotient)));
        }
        this.setDay(endDays.intValue());
        block9: for (int i = 0; i <= 5; ++i) {
            if (!fieldUndefined[i]) continue;
            switch (i) {
                case 0: {
                    this.setYear(Integer.MIN_VALUE);
                    continue block9;
                }
                case 1: {
                    this.setMonth(Integer.MIN_VALUE);
                    continue block9;
                }
                case 2: {
                    this.setDay(Integer.MIN_VALUE);
                    continue block9;
                }
                case 3: {
                    this.setHour(Integer.MIN_VALUE);
                    continue block9;
                }
                case 4: {
                    this.setMinute(Integer.MIN_VALUE);
                    continue block9;
                }
                case 5: {
                    this.setSecond(Integer.MIN_VALUE);
                    this.setFractionalSecond(null);
                }
            }
        }
    }

    private static int maximumDayInMonthFor(BigInteger year, int month) {
        if (month != 2) {
            return DaysInMonth.table[month];
        }
        if (year.mod(FOUR_HUNDRED).equals(BigInteger.ZERO) || !year.mod(HUNDRED).equals(BigInteger.ZERO) && year.mod(FOUR).equals(BigInteger.ZERO)) {
            return 29;
        }
        return DaysInMonth.table[month];
    }

    private static int maximumDayInMonthFor(int year, int month) {
        if (month != 2) {
            return DaysInMonth.table[month];
        }
        if (year % 400 == 0 || year % 100 != 0 && year % 4 == 0) {
            return 29;
        }
        return DaysInMonth.table[2];
    }

    @Override
    public GregorianCalendar toGregorianCalendar() {
        GregorianCalendar result = null;
        int DEFAULT_TIMEZONE_OFFSET = Integer.MIN_VALUE;
        TimeZone tz = this.getTimeZone(Integer.MIN_VALUE);
        Locale locale = Locale.getDefault();
        result = new GregorianCalendar(tz, locale);
        result.clear();
        result.setGregorianChange(PURE_GREGORIAN_CHANGE);
        if (this.year != Integer.MIN_VALUE) {
            if (this.eon == null) {
                result.set(0, this.year < 0 ? 0 : 1);
                result.set(1, Math.abs(this.year));
            } else {
                BigInteger eonAndYear = this.getEonAndYear();
                result.set(0, eonAndYear.signum() == -1 ? 0 : 1);
                result.set(1, eonAndYear.abs().intValue());
            }
        }
        if (this.month != Integer.MIN_VALUE) {
            result.set(2, this.month - 1);
        }
        if (this.day != Integer.MIN_VALUE) {
            result.set(5, this.day);
        }
        if (this.hour != Integer.MIN_VALUE) {
            result.set(11, this.hour);
        }
        if (this.minute != Integer.MIN_VALUE) {
            result.set(12, this.minute);
        }
        if (this.second != Integer.MIN_VALUE) {
            result.set(13, this.second);
        }
        if (this.fractionalSecond != null) {
            result.set(14, this.getMillisecond());
        }
        return result;
    }

    @Override
    public GregorianCalendar toGregorianCalendar(TimeZone timezone2, Locale aLocale, XMLGregorianCalendar defaults) {
        int defaultYear;
        GregorianCalendar result = null;
        TimeZone tz = timezone2;
        if (tz == null) {
            int defaultZoneoffset = Integer.MIN_VALUE;
            if (defaults != null) {
                defaultZoneoffset = defaults.getTimezone();
            }
            tz = this.getTimeZone(defaultZoneoffset);
        }
        if (aLocale == null) {
            aLocale = Locale.getDefault();
        }
        result = new GregorianCalendar(tz, aLocale);
        result.clear();
        result.setGregorianChange(PURE_GREGORIAN_CHANGE);
        if (this.year != Integer.MIN_VALUE) {
            if (this.eon == null) {
                result.set(0, this.year < 0 ? 0 : 1);
                result.set(1, Math.abs(this.year));
            } else {
                BigInteger eonAndYear = this.getEonAndYear();
                result.set(0, eonAndYear.signum() == -1 ? 0 : 1);
                result.set(1, eonAndYear.abs().intValue());
            }
        } else if (defaults != null && (defaultYear = defaults.getYear()) != Integer.MIN_VALUE) {
            if (defaults.getEon() == null) {
                result.set(0, defaultYear < 0 ? 0 : 1);
                result.set(1, Math.abs(defaultYear));
            } else {
                BigInteger defaultEonAndYear = defaults.getEonAndYear();
                result.set(0, defaultEonAndYear.signum() == -1 ? 0 : 1);
                result.set(1, defaultEonAndYear.abs().intValue());
            }
        }
        if (this.month != Integer.MIN_VALUE) {
            result.set(2, this.month - 1);
        } else {
            int defaultMonth;
            int n = defaultMonth = defaults != null ? defaults.getMonth() : Integer.MIN_VALUE;
            if (defaultMonth != Integer.MIN_VALUE) {
                result.set(2, defaultMonth - 1);
            }
        }
        if (this.day != Integer.MIN_VALUE) {
            result.set(5, this.day);
        } else {
            int defaultDay;
            int n = defaultDay = defaults != null ? defaults.getDay() : Integer.MIN_VALUE;
            if (defaultDay != Integer.MIN_VALUE) {
                result.set(5, defaultDay);
            }
        }
        if (this.hour != Integer.MIN_VALUE) {
            result.set(11, this.hour);
        } else {
            int defaultHour;
            int n = defaultHour = defaults != null ? defaults.getHour() : Integer.MIN_VALUE;
            if (defaultHour != Integer.MIN_VALUE) {
                result.set(11, defaultHour);
            }
        }
        if (this.minute != Integer.MIN_VALUE) {
            result.set(12, this.minute);
        } else {
            int defaultMinute;
            int n = defaultMinute = defaults != null ? defaults.getMinute() : Integer.MIN_VALUE;
            if (defaultMinute != Integer.MIN_VALUE) {
                result.set(12, defaultMinute);
            }
        }
        if (this.second != Integer.MIN_VALUE) {
            result.set(13, this.second);
        } else {
            int defaultSecond;
            int n = defaultSecond = defaults != null ? defaults.getSecond() : Integer.MIN_VALUE;
            if (defaultSecond != Integer.MIN_VALUE) {
                result.set(13, defaultSecond);
            }
        }
        if (this.fractionalSecond != null) {
            result.set(14, this.getMillisecond());
        } else {
            BigDecimal defaultFractionalSecond;
            BigDecimal bigDecimal = defaultFractionalSecond = defaults != null ? defaults.getFractionalSecond() : null;
            if (defaultFractionalSecond != null) {
                result.set(14, defaults.getMillisecond());
            }
        }
        return result;
    }

    @Override
    public TimeZone getTimeZone(int defaultZoneoffset) {
        TimeZone result = null;
        int zoneoffset = this.getTimezone();
        if (zoneoffset == Integer.MIN_VALUE) {
            zoneoffset = defaultZoneoffset;
        }
        if (zoneoffset == Integer.MIN_VALUE) {
            result = TimeZone.getDefault();
        } else {
            char sign;
            char c = sign = zoneoffset < 0 ? (char)'-' : '+';
            if (sign == '-') {
                zoneoffset = -zoneoffset;
            }
            int hour = zoneoffset / 60;
            int minutes = zoneoffset - hour * 60;
            StringBuilder customTimezoneId = new StringBuilder(8);
            customTimezoneId.append("GMT");
            customTimezoneId.append(sign);
            customTimezoneId.append(hour);
            if (minutes != 0) {
                if (minutes < 10) {
                    customTimezoneId.append('0');
                }
                customTimezoneId.append(minutes);
            }
            result = TimeZone.getTimeZone(customTimezoneId.toString());
        }
        return result;
    }

    @Override
    public Object clone() {
        return new XMLGregorianCalendarImpl(this.getEonAndYear(), this.month, this.day, this.hour, this.minute, this.second, this.fractionalSecond, this.timezone);
    }

    @Override
    public void clear() {
        this.eon = null;
        this.year = Integer.MIN_VALUE;
        this.month = Integer.MIN_VALUE;
        this.day = Integer.MIN_VALUE;
        this.timezone = Integer.MIN_VALUE;
        this.hour = Integer.MIN_VALUE;
        this.minute = Integer.MIN_VALUE;
        this.second = Integer.MIN_VALUE;
        this.fractionalSecond = null;
    }

    @Override
    public void setMillisecond(int millisecond) {
        if (millisecond == Integer.MIN_VALUE) {
            this.fractionalSecond = null;
        } else {
            this.checkFieldValueConstraint(6, millisecond);
            this.fractionalSecond = BigDecimal.valueOf(millisecond, 3);
        }
    }

    @Override
    public void setFractionalSecond(BigDecimal fractional) {
        if (fractional != null && (fractional.compareTo(DECIMAL_ZERO) < 0 || fractional.compareTo(DECIMAL_ONE) > 0)) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidFractional", new Object[]{fractional}));
        }
        this.fractionalSecond = fractional;
    }

    private static boolean isDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    private String format(String format) {
        StringBuilder buf = new StringBuilder();
        int fidx = 0;
        int flen = format.length();
        block9: while (fidx < flen) {
            char fch;
            if ((fch = format.charAt(fidx++)) != '%') {
                buf.append(fch);
                continue;
            }
            switch (format.charAt(fidx++)) {
                case 'Y': {
                    if (this.eon == null) {
                        int absYear = this.year;
                        if (absYear < 0) {
                            buf.append('-');
                            absYear = -this.year;
                        }
                        this.printNumber(buf, absYear, 4);
                        continue block9;
                    }
                    this.printNumber(buf, this.getEonAndYear(), 4);
                    continue block9;
                }
                case 'M': {
                    this.printNumber(buf, this.getMonth(), 2);
                    continue block9;
                }
                case 'D': {
                    this.printNumber(buf, this.getDay(), 2);
                    continue block9;
                }
                case 'h': {
                    this.printNumber(buf, this.getHour(), 2);
                    continue block9;
                }
                case 'm': {
                    this.printNumber(buf, this.getMinute(), 2);
                    continue block9;
                }
                case 's': {
                    this.printNumber(buf, this.getSecond(), 2);
                    if (this.getFractionalSecond() == null) continue block9;
                    String frac = this.toString(this.getFractionalSecond());
                    buf.append(frac.substring(1, frac.length()));
                    continue block9;
                }
                case 'z': {
                    int offset = this.getTimezone();
                    if (offset == 0) {
                        buf.append('Z');
                        continue block9;
                    }
                    if (offset == Integer.MIN_VALUE) continue block9;
                    if (offset < 0) {
                        buf.append('-');
                        offset *= -1;
                    } else {
                        buf.append('+');
                    }
                    this.printNumber(buf, offset / 60, 2);
                    buf.append(':');
                    this.printNumber(buf, offset % 60, 2);
                    continue block9;
                }
            }
            throw new InternalError();
        }
        return buf.toString();
    }

    private void printNumber(StringBuilder out, int number, int nDigits) {
        String s = String.valueOf(number);
        for (int i = s.length(); i < nDigits; ++i) {
            out.append('0');
        }
        out.append(s);
    }

    private void printNumber(StringBuilder out, BigInteger number, int nDigits) {
        String s = number.toString();
        for (int i = s.length(); i < nDigits; ++i) {
            out.append('0');
        }
        out.append(s);
    }

    private String toString(BigDecimal bd) {
        StringBuilder buf;
        String intString = bd.unscaledValue().toString();
        int scale = bd.scale();
        if (scale == 0) {
            return intString;
        }
        int insertionPoint = intString.length() - scale;
        if (insertionPoint == 0) {
            return "0." + intString;
        }
        if (insertionPoint > 0) {
            buf = new StringBuilder(intString);
            buf.insert(insertionPoint, '.');
        } else {
            buf = new StringBuilder(3 - insertionPoint + intString.length());
            buf.append("0.");
            for (int i = 0; i < -insertionPoint; ++i) {
                buf.append('0');
            }
            buf.append(intString);
        }
        return buf.toString();
    }

    static BigInteger sanitize(Number value, int signum) {
        if (signum == 0 || value == null) {
            return BigInteger.ZERO;
        }
        return signum < 0 ? ((BigInteger)value).negate() : (BigInteger)value;
    }

    @Override
    public void reset() {
        this.eon = this.orig_eon;
        this.year = this.orig_year;
        this.month = this.orig_month;
        this.day = this.orig_day;
        this.hour = this.orig_hour;
        this.minute = this.orig_minute;
        this.second = this.orig_second;
        this.fractionalSecond = this.orig_fracSeconds;
        this.timezone = this.orig_timezone;
    }

    private final class Parser {
        private final String format;
        private final String value;
        private final int flen;
        private final int vlen;
        private int fidx;
        private int vidx;

        private Parser(String format, String value) {
            this.format = format;
            this.value = value;
            this.flen = format.length();
            this.vlen = value.length();
        }

        public void parse() throws IllegalArgumentException {
            block9: while (this.fidx < this.flen) {
                char fch;
                if ((fch = this.format.charAt(this.fidx++)) != '%') {
                    this.skip(fch);
                    continue;
                }
                switch (this.format.charAt(this.fidx++)) {
                    case 'Y': {
                        this.parseYear();
                        continue block9;
                    }
                    case 'M': {
                        XMLGregorianCalendarImpl.this.setMonth(this.parseInt(2, 2));
                        continue block9;
                    }
                    case 'D': {
                        XMLGregorianCalendarImpl.this.setDay(this.parseInt(2, 2));
                        continue block9;
                    }
                    case 'h': {
                        XMLGregorianCalendarImpl.this.setHour(this.parseInt(2, 2));
                        continue block9;
                    }
                    case 'm': {
                        XMLGregorianCalendarImpl.this.setMinute(this.parseInt(2, 2));
                        continue block9;
                    }
                    case 's': {
                        XMLGregorianCalendarImpl.this.setSecond(this.parseInt(2, 2));
                        if (this.peek() != '.') continue block9;
                        XMLGregorianCalendarImpl.this.setFractionalSecond(this.parseBigDecimal());
                        continue block9;
                    }
                    case 'z': {
                        char vch = this.peek();
                        if (vch == 'Z') {
                            ++this.vidx;
                            XMLGregorianCalendarImpl.this.setTimezone(0);
                            continue block9;
                        }
                        if (vch != '+' && vch != '-') continue block9;
                        ++this.vidx;
                        int h = this.parseInt(2, 2);
                        this.skip(':');
                        int m = this.parseInt(2, 2);
                        XMLGregorianCalendarImpl.this.setTimezone((h * 60 + m) * (vch == '+' ? 1 : -1));
                        continue block9;
                    }
                }
                throw new InternalError();
            }
            if (this.vidx != this.vlen) {
                throw new IllegalArgumentException(this.value);
            }
        }

        private char peek() throws IllegalArgumentException {
            if (this.vidx == this.vlen) {
                return '\uffff';
            }
            return this.value.charAt(this.vidx);
        }

        private char read() throws IllegalArgumentException {
            if (this.vidx == this.vlen) {
                throw new IllegalArgumentException(this.value);
            }
            return this.value.charAt(this.vidx++);
        }

        private void skip(char ch) throws IllegalArgumentException {
            if (this.read() != ch) {
                throw new IllegalArgumentException(this.value);
            }
        }

        private void parseYear() throws IllegalArgumentException {
            int vstart = this.vidx++;
            int sign = 0;
            if (this.peek() == '-') {
                sign = 1;
            }
            while (XMLGregorianCalendarImpl.isDigit(this.peek())) {
                ++this.vidx;
            }
            int digits = this.vidx - vstart - sign;
            if (digits < 4) {
                throw new IllegalArgumentException(this.value);
            }
            String yearString = this.value.substring(vstart, this.vidx);
            if (digits < 10) {
                XMLGregorianCalendarImpl.this.setYear(Integer.parseInt(yearString));
            } else {
                XMLGregorianCalendarImpl.this.setYear(new BigInteger(yearString));
            }
        }

        private int parseInt(int minDigits, int maxDigits) throws IllegalArgumentException {
            int vstart = this.vidx;
            while (XMLGregorianCalendarImpl.isDigit(this.peek()) && this.vidx - vstart < maxDigits) {
                ++this.vidx;
            }
            if (this.vidx - vstart < minDigits) {
                throw new IllegalArgumentException(this.value);
            }
            return Integer.parseInt(this.value.substring(vstart, this.vidx));
        }

        private BigDecimal parseBigDecimal() throws IllegalArgumentException {
            int vstart = this.vidx++;
            if (this.peek() != '.') {
                throw new IllegalArgumentException(this.value);
            }
            while (XMLGregorianCalendarImpl.isDigit(this.peek())) {
                ++this.vidx;
            }
            return new BigDecimal(this.value.substring(vstart, this.vidx));
        }
    }

    private static class DaysInMonth {
        private static final int[] table = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

        private DaysInMonth() {
        }
    }
}

