/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.fill.filter;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.filter.AbstractMonthIntervalFillFilter;

public class MonthIntervalUSFillFilter
extends AbstractMonthIntervalFillFilter {
    public MonthIntervalUSFillFilter(int monthDuration, long nonMonthDuration, ZoneId zone) {
        super(monthDuration, nonMonthDuration, zone);
    }

    @Override
    public boolean needFill(long time, long previousTime) {
        long smaller = Math.min(time, previousTime);
        long greater = Math.max(time, previousTime);
        Instant smallerInstant = Instant.ofEpochSecond(smaller / 1000000L, smaller % 1000000L);
        LocalDateTime smallerDateTime = LocalDateTime.ofInstant(smallerInstant, this.zone);
        ZoneOffset smallerOffset = this.zone.getRules().getStandardOffset(smallerInstant);
        Instant upper = smallerDateTime.plusMonths(this.monthDuration).plus(this.nonMonthDuration, ChronoUnit.MICROS).toInstant(smallerOffset);
        long timeInUs = upper.getLong(ChronoField.MICRO_OF_SECOND) + upper.getEpochSecond() * 1000000L;
        return timeInUs >= greater;
    }
}

