/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import io.moquette.broker.PostOffice;
import io.moquette.broker.SessionCommand;
import io.moquette.broker.SessionEventLoop;
import io.moquette.interception.BrokerInterceptor;
import io.moquette.interception.messages.InterceptExceptionMessage;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.FutureTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SessionEventLoopGroup {
    private static final Logger LOG = LoggerFactory.getLogger(SessionEventLoopGroup.class);
    private final SessionEventLoop[] sessionExecutors;
    private final BlockingQueue<FutureTask<String>>[] sessionQueues;
    private final int eventLoops = Runtime.getRuntime().availableProcessors();
    private final ConcurrentMap<String, Throwable> loopThrownExceptions = new ConcurrentHashMap<String, Throwable>();

    SessionEventLoopGroup(BrokerInterceptor interceptor, int sessionQueueSize) {
        int i;
        this.sessionQueues = new BlockingQueue[this.eventLoops];
        for (i = 0; i < this.eventLoops; ++i) {
            this.sessionQueues[i] = new ArrayBlockingQueue<FutureTask<String>>(sessionQueueSize);
        }
        this.sessionExecutors = new SessionEventLoop[this.eventLoops];
        for (i = 0; i < this.eventLoops; ++i) {
            SessionEventLoop newLoop = new SessionEventLoop(this.sessionQueues[i]);
            newLoop.setName(this.sessionLoopName(i));
            newLoop.setUncaughtExceptionHandler((loopThread, ex) -> {
                this.loopThrownExceptions.put(loopThread.getName(), ex);
                interceptor.notifyLoopException(new InterceptExceptionMessage(ex));
            });
            newLoop.start();
            this.sessionExecutors[i] = newLoop;
        }
    }

    int targetQueueOrdinal(String clientId) {
        return Math.abs(clientId.hashCode()) % this.eventLoops;
    }

    private String sessionLoopName(int i) {
        return "Session Executor " + i;
    }

    String sessionLoopThreadName(String clientId) {
        int targetQueueId = this.targetQueueOrdinal(clientId);
        return this.sessionLoopName(targetQueueId);
    }

    public PostOffice.RouteResult routeCommand(String clientId, String actionDescription, Callable<Void> action) {
        SessionCommand cmd = new SessionCommand(clientId, action);
        if (clientId == null) {
            LOG.warn("Routing collision for action [{}]", (Object)actionDescription);
            return PostOffice.RouteResult.failed(null, "Seems awaiting new route feature completion, skipping.");
        }
        int targetQueueId = this.targetQueueOrdinal(cmd.getSessionId());
        LOG.debug("Routing cmd [{}] for session [{}] to event processor {}", new Object[]{actionDescription, cmd.getSessionId(), targetQueueId});
        FutureTask<String> task = new FutureTask<String>(() -> {
            cmd.execute();
            cmd.complete();
            return cmd.getSessionId();
        });
        if (Thread.currentThread() == this.sessionExecutors[targetQueueId]) {
            SessionEventLoop.executeTask(task);
            return PostOffice.RouteResult.success(clientId, cmd.completableFuture());
        }
        if (this.sessionQueues[targetQueueId].offer(task)) {
            return PostOffice.RouteResult.success(clientId, cmd.completableFuture());
        }
        LOG.warn("Session command queue {} is full executing action {}", (Object)targetQueueId, (Object)actionDescription);
        return PostOffice.RouteResult.failed(clientId);
    }

    public void terminate() {
        for (SessionEventLoop processor : this.sessionExecutors) {
            processor.interrupt();
        }
        for (SessionEventLoop processor : this.sessionExecutors) {
            try {
                processor.join(5000L);
            }
            catch (InterruptedException ex) {
                LOG.info("Interrupted while joining session event loop {}", (Object)processor.getName(), (Object)ex);
            }
        }
        for (Map.Entry entry : this.loopThrownExceptions.entrySet()) {
            String threadName = (String)entry.getKey();
            Throwable threadError = (Throwable)entry.getValue();
            LOG.error("Session event loop {} terminated with error", (Object)threadName, (Object)threadError);
        }
    }

    public int getEventLoopCount() {
        return this.eventLoops;
    }
}

