/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.common.regexp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DFA {
    private final int start;
    private final ArrayList<Integer> acceptStates;
    private final List<List<Transition>> transitions;

    public DFA(int start, ArrayList<Integer> acceptStates, List<List<Transition>> transitions) {
        this.start = start;
        this.acceptStates = Objects.requireNonNull(acceptStates, "acceptStates is null");
        this.transitions = Collections.unmodifiableList(new ArrayList<List<Transition>>(transitions));
    }

    public List<List<Transition>> getTransitions() {
        return this.transitions;
    }

    public ArrayList<Integer> getAcceptStates() {
        return this.acceptStates;
    }

    public int getStart() {
        return this.start;
    }

    public static class Builder {
        private int nextId;
        private int start;
        private final ArrayList<Integer> acceptStates = new ArrayList();
        private final List<List<Transition>> transitions = new ArrayList<List<Transition>>();

        public int addState(boolean accept) {
            int state = this.nextId++;
            this.transitions.add(new ArrayList());
            if (accept) {
                this.acceptStates.add(state);
            }
            return state;
        }

        public int addStartState(boolean accept) {
            this.start = this.addState(accept);
            return this.start;
        }

        public void addTransition(int from, int value, int to) {
            this.transitions.get(from).add(new Transition(value, to));
        }

        public DFA build() {
            return new DFA(this.start, this.acceptStates, this.transitions);
        }
    }

    public static class Transition {
        private final int value;
        private final int target;

        public Transition(int value, int target) {
            this.value = value;
            this.target = target;
        }

        public int getTarget() {
            return this.target;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("-[%s]-> %s", this.value, this.target);
        }
    }
}

