/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.ApplyGuard;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import io.smallrye.faulttolerance.config.ApplyGuardConfig;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public final class ApplyGuardConfigImpl
implements ApplyGuardConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final boolean onMethod;
    private final String description;
    private final String configKey;
    private final ApplyGuard instance;
    private String _value;

    private ApplyGuardConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.onMethod = method.annotationsPresentDirectly.contains(ApplyGuard.class);
        this.description = method.method.toString();
        this.configKey = this.onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.applyGuard;
    }

    public static ApplyGuardConfigImpl create(FaultToleranceMethod method) {
        if (method.applyGuard == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled((String)"apply-guard.enabled", (String)"ApplyGuard/enabled", (MethodDescriptor)method.method)) {
            return null;
        }
        return new ApplyGuardConfigImpl(method);
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return ApplyGuard.class;
    }

    public String value() {
        if (this._value == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".apply-guard.value";
            Object oldKey = this.configKey + "/ApplyGuard/value";
            this._value = config.getOptionalValue((String)newKey, String.class).or(() -> ApplyGuardConfigImpl.lambda$value$0(config, (String)oldKey)).orElse(null);
            if (this._value == null) {
                newKey = "smallrye.faulttolerance.global.apply-guard.value";
                oldKey = "ApplyGuard/value";
                this._value = config.getOptionalValue((String)newKey, String.class).or(() -> ApplyGuardConfigImpl.lambda$value$1(config, (String)oldKey)).orElse(null);
            }
            if (this._value == null) {
                this._value = this.instance.value();
            }
        }
        return this._value;
    }

    public void materialize() {
        this.value();
    }

    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @ApplyGuard on " + this.description + ": " + reason);
    }

    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @ApplyGuard." + member + " on " + this.description + ": " + reason);
    }

    private static /* synthetic */ Optional lambda$value$1(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, String.class);
    }

    private static /* synthetic */ Optional lambda$value$0(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, String.class);
    }
}

