/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.pool;

import java.util.Collections;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.pool.LaxConnPool;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.pool.PoolStats;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TestLaxConnPool {
    TestLaxConnPool() {
    }

    @Test
    void testEmptyPool() {
        try (LaxConnPool pool = new LaxConnPool(2);){
            PoolStats totals = pool.getTotalStats();
            Assertions.assertEquals((int)0, (int)totals.getAvailable());
            Assertions.assertEquals((int)0, (int)totals.getLeased());
            Assertions.assertEquals((int)0, (int)totals.getPending());
            Assertions.assertEquals((int)0, (int)totals.getMax());
            Assertions.assertEquals(Collections.emptySet(), (Object)pool.getRoutes());
            PoolStats stats = pool.getStats((Object)"somehost");
            Assertions.assertEquals((int)0, (int)stats.getAvailable());
            Assertions.assertEquals((int)0, (int)stats.getLeased());
            Assertions.assertEquals((int)0, (int)stats.getPending());
            Assertions.assertEquals((int)2, (int)stats.getMax());
            Assertions.assertEquals((Object)"[leased: 0][available: 0][pending: 0]", (Object)pool.toString());
        }
    }

    @Test
    void testInvalidConstruction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new LaxConnPool(-1));
    }

    @Test
    void testLeaseRelease() throws Exception {
        HttpConnection conn1 = (HttpConnection)Mockito.mock(HttpConnection.class);
        HttpConnection conn2 = (HttpConnection)Mockito.mock(HttpConnection.class);
        HttpConnection conn3 = (HttpConnection)Mockito.mock(HttpConnection.class);
        try (LaxConnPool pool = new LaxConnPool(2);){
            Future future1 = pool.lease((Object)"somehost", null);
            Future future2 = pool.lease((Object)"somehost", null);
            Future future3 = pool.lease((Object)"otherhost", null);
            PoolEntry entry1 = (PoolEntry)future1.get();
            Assertions.assertNotNull((Object)entry1);
            entry1.assignConnection((ModalCloseable)conn1);
            PoolEntry entry2 = (PoolEntry)future2.get();
            Assertions.assertNotNull((Object)entry2);
            entry2.assignConnection((ModalCloseable)conn2);
            PoolEntry entry3 = (PoolEntry)future3.get();
            Assertions.assertNotNull((Object)entry3);
            entry3.assignConnection((ModalCloseable)conn3);
            pool.release(entry1, true);
            pool.release(entry2, true);
            pool.release(entry3, false);
            ((HttpConnection)Mockito.verify((Object)conn1, (VerificationMode)Mockito.never())).close((CloseMode)ArgumentMatchers.any());
            ((HttpConnection)Mockito.verify((Object)conn2, (VerificationMode)Mockito.never())).close((CloseMode)ArgumentMatchers.any());
            ((HttpConnection)Mockito.verify((Object)conn3, (VerificationMode)Mockito.times((int)1))).close(CloseMode.GRACEFUL);
            PoolStats totals = pool.getTotalStats();
            Assertions.assertEquals((int)2, (int)totals.getAvailable());
            Assertions.assertEquals((int)0, (int)totals.getLeased());
            Assertions.assertEquals((int)0, (int)totals.getPending());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testLeaseReleaseMultiThreaded() throws Exception {
        try (LaxConnPool pool = new LaxConnPool(2);){
            int c = 10;
            CountDownLatch latch = new CountDownLatch(10);
            AtomicInteger n = new AtomicInteger(110);
            AtomicReference exRef = new AtomicReference();
            ExecutorService executorService = Executors.newFixedThreadPool(10);
            try {
                Random rnd = new Random();
                for (int i = 0; i < 10; ++i) {
                    executorService.execute(() -> {
                        try {
                            while (n.decrementAndGet() > 0) {
                                try {
                                    Future future = pool.lease((Object)"somehost", null);
                                    PoolEntry poolEntry = (PoolEntry)future.get(1L, TimeUnit.MINUTES);
                                    Thread.sleep(rnd.nextInt(1));
                                    pool.release(poolEntry, false);
                                }
                                catch (Exception ex) {
                                    Assertions.fail((String)ex.getMessage(), (Throwable)ex);
                                }
                            }
                        }
                        catch (AssertionError ex) {
                            exRef.compareAndSet(null, ex);
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                }
                Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.MINUTES));
            }
            finally {
                executorService.shutdownNow();
            }
            AssertionError assertionError = (AssertionError)exRef.get();
            if (assertionError != null) {
                throw assertionError;
            }
        }
    }

    @Test
    void testLeaseInvalid() {
        try (LaxConnPool pool = new LaxConnPool(2);){
            Assertions.assertThrows(NullPointerException.class, () -> pool.lease(null, null, Timeout.ZERO_MILLISECONDS, null));
        }
    }

    @Test
    void testReleaseUnknownEntry() {
        try (LaxConnPool pool = new LaxConnPool(2);){
            Assertions.assertThrows(IllegalStateException.class, () -> pool.release(new PoolEntry((Object)"somehost"), true));
        }
    }

    @Test
    void testMaxLimits() throws Exception {
        HttpConnection conn1 = (HttpConnection)Mockito.mock(HttpConnection.class);
        HttpConnection conn2 = (HttpConnection)Mockito.mock(HttpConnection.class);
        HttpConnection conn3 = (HttpConnection)Mockito.mock(HttpConnection.class);
        try (LaxConnPool pool = new LaxConnPool(2);){
            pool.setMaxPerRoute((Object)"somehost", 2);
            pool.setMaxPerRoute((Object)"otherhost", 1);
            Future future1 = pool.lease((Object)"somehost", null);
            Future future2 = pool.lease((Object)"somehost", null);
            Future future3 = pool.lease((Object)"otherhost", null);
            PoolEntry entry1 = (PoolEntry)future1.get();
            Assertions.assertNotNull((Object)entry1);
            entry1.assignConnection((ModalCloseable)conn1);
            PoolEntry entry2 = (PoolEntry)future2.get();
            Assertions.assertNotNull((Object)entry2);
            entry2.assignConnection((ModalCloseable)conn2);
            PoolEntry entry3 = (PoolEntry)future3.get();
            Assertions.assertNotNull((Object)entry3);
            entry3.assignConnection((ModalCloseable)conn3);
            pool.release(entry1, true);
            pool.release(entry2, true);
            pool.release(entry3, true);
            PoolStats totals = pool.getTotalStats();
            Assertions.assertEquals((int)3, (int)totals.getAvailable());
            Assertions.assertEquals((int)0, (int)totals.getLeased());
            Assertions.assertEquals((int)0, (int)totals.getPending());
            Future future4 = pool.lease((Object)"somehost", null);
            Future future5 = pool.lease((Object)"somehost", null);
            Future future6 = pool.lease((Object)"otherhost", null);
            Future future7 = pool.lease((Object)"somehost", null);
            Future future8 = pool.lease((Object)"somehost", null);
            Future future9 = pool.lease((Object)"otherhost", null);
            Assertions.assertTrue((boolean)future4.isDone());
            PoolEntry entry4 = (PoolEntry)future4.get();
            Assertions.assertNotNull((Object)entry4);
            Assertions.assertSame((Object)conn2, (Object)entry4.getConnection());
            Assertions.assertTrue((boolean)future5.isDone());
            PoolEntry entry5 = (PoolEntry)future5.get();
            Assertions.assertNotNull((Object)entry5);
            Assertions.assertSame((Object)conn1, (Object)entry5.getConnection());
            Assertions.assertTrue((boolean)future6.isDone());
            PoolEntry entry6 = (PoolEntry)future6.get();
            Assertions.assertNotNull((Object)entry6);
            Assertions.assertSame((Object)conn3, (Object)entry6.getConnection());
            Assertions.assertFalse((boolean)future7.isDone());
            Assertions.assertFalse((boolean)future8.isDone());
            Assertions.assertFalse((boolean)future9.isDone());
            pool.release(entry4, true);
            pool.release(entry5, false);
            pool.release(entry6, true);
            Assertions.assertTrue((boolean)future7.isDone());
            PoolEntry entry7 = (PoolEntry)future7.get();
            Assertions.assertNotNull((Object)entry7);
            Assertions.assertSame((Object)conn2, (Object)entry7.getConnection());
            Assertions.assertTrue((boolean)future8.isDone());
            PoolEntry entry8 = (PoolEntry)future8.get();
            Assertions.assertNotNull((Object)entry8);
            Assertions.assertNull((Object)entry8.getConnection());
            Assertions.assertTrue((boolean)future9.isDone());
            PoolEntry entry9 = (PoolEntry)future9.get();
            Assertions.assertNotNull((Object)entry9);
            Assertions.assertSame((Object)conn3, (Object)entry9.getConnection());
        }
    }

    @Test
    void testCreateNewIfExpired() throws Exception {
        HttpConnection conn1 = (HttpConnection)Mockito.mock(HttpConnection.class);
        try (LaxConnPool pool = new LaxConnPool(2);){
            Future future1 = pool.lease((Object)"somehost", null);
            Assertions.assertTrue((boolean)future1.isDone());
            PoolEntry entry1 = (PoolEntry)future1.get();
            Assertions.assertNotNull((Object)entry1);
            entry1.assignConnection((ModalCloseable)conn1);
            entry1.updateExpiry(TimeValue.of((long)1L, (TimeUnit)TimeUnit.MILLISECONDS));
            pool.release(entry1, true);
            Thread.sleep(200L);
            Future future2 = pool.lease((Object)"somehost", null);
            Assertions.assertTrue((boolean)future2.isDone());
            ((HttpConnection)Mockito.verify((Object)conn1)).close(CloseMode.GRACEFUL);
            PoolStats totals = pool.getTotalStats();
            Assertions.assertEquals((int)0, (int)totals.getAvailable());
            Assertions.assertEquals((int)1, (int)totals.getLeased());
            Assertions.assertEquals(Collections.singleton("somehost"), (Object)pool.getRoutes());
            PoolStats stats = pool.getStats((Object)"somehost");
            Assertions.assertEquals((int)0, (int)stats.getAvailable());
            Assertions.assertEquals((int)1, (int)stats.getLeased());
        }
    }

    @Test
    void testCloseExpired() throws Exception {
        HttpConnection conn1 = (HttpConnection)Mockito.mock(HttpConnection.class);
        HttpConnection conn2 = (HttpConnection)Mockito.mock(HttpConnection.class);
        try (LaxConnPool pool = new LaxConnPool(2);){
            Future future1 = pool.lease((Object)"somehost", null);
            Future future2 = pool.lease((Object)"somehost", null);
            Assertions.assertTrue((boolean)future1.isDone());
            PoolEntry entry1 = (PoolEntry)future1.get();
            Assertions.assertNotNull((Object)entry1);
            entry1.assignConnection((ModalCloseable)conn1);
            Assertions.assertTrue((boolean)future2.isDone());
            PoolEntry entry2 = (PoolEntry)future2.get();
            Assertions.assertNotNull((Object)entry2);
            entry2.assignConnection((ModalCloseable)conn2);
            entry1.updateExpiry(TimeValue.of((long)1L, (TimeUnit)TimeUnit.MILLISECONDS));
            pool.release(entry1, true);
            Thread.sleep(200L);
            entry2.updateExpiry(TimeValue.of((long)1000L, (TimeUnit)TimeUnit.SECONDS));
            pool.release(entry2, true);
            pool.closeExpired();
            ((HttpConnection)Mockito.verify((Object)conn1)).close(CloseMode.GRACEFUL);
            ((HttpConnection)Mockito.verify((Object)conn2, (VerificationMode)Mockito.never())).close((CloseMode)ArgumentMatchers.any());
            PoolStats totals = pool.getTotalStats();
            Assertions.assertEquals((int)1, (int)totals.getAvailable());
            Assertions.assertEquals((int)0, (int)totals.getLeased());
            Assertions.assertEquals((int)0, (int)totals.getPending());
            PoolStats stats = pool.getStats((Object)"somehost");
            Assertions.assertEquals((int)1, (int)stats.getAvailable());
            Assertions.assertEquals((int)0, (int)stats.getLeased());
            Assertions.assertEquals((int)0, (int)stats.getPending());
        }
    }

    @Test
    void testCloseIdle() throws Exception {
        HttpConnection conn1 = (HttpConnection)Mockito.mock(HttpConnection.class);
        HttpConnection conn2 = (HttpConnection)Mockito.mock(HttpConnection.class);
        try (LaxConnPool pool = new LaxConnPool(2);){
            Future future1 = pool.lease((Object)"somehost", null);
            Future future2 = pool.lease((Object)"somehost", null);
            Assertions.assertTrue((boolean)future1.isDone());
            PoolEntry entry1 = (PoolEntry)future1.get();
            Assertions.assertNotNull((Object)entry1);
            entry1.assignConnection((ModalCloseable)conn1);
            Assertions.assertTrue((boolean)future2.isDone());
            PoolEntry entry2 = (PoolEntry)future2.get();
            Assertions.assertNotNull((Object)entry2);
            entry2.assignConnection((ModalCloseable)conn2);
            entry1.updateState(null);
            pool.release(entry1, true);
            Thread.sleep(200L);
            entry2.updateState(null);
            pool.release(entry2, true);
            pool.closeIdle(TimeValue.of((long)50L, (TimeUnit)TimeUnit.MILLISECONDS));
            ((HttpConnection)Mockito.verify((Object)conn1)).close(CloseMode.GRACEFUL);
            ((HttpConnection)Mockito.verify((Object)conn2, (VerificationMode)Mockito.never())).close((CloseMode)ArgumentMatchers.any());
            PoolStats totals = pool.getTotalStats();
            Assertions.assertEquals((int)1, (int)totals.getAvailable());
            Assertions.assertEquals((int)0, (int)totals.getLeased());
            Assertions.assertEquals((int)0, (int)totals.getPending());
            PoolStats stats = pool.getStats((Object)"somehost");
            Assertions.assertEquals((int)1, (int)stats.getAvailable());
            Assertions.assertEquals((int)0, (int)stats.getLeased());
            Assertions.assertEquals((int)0, (int)stats.getPending());
            pool.closeIdle(TimeValue.of((long)-1L, (TimeUnit)TimeUnit.MILLISECONDS));
            ((HttpConnection)Mockito.verify((Object)conn2)).close(CloseMode.GRACEFUL);
            totals = pool.getTotalStats();
            Assertions.assertEquals((int)0, (int)totals.getAvailable());
            Assertions.assertEquals((int)0, (int)totals.getLeased());
            Assertions.assertEquals((int)0, (int)totals.getPending());
            stats = pool.getStats((Object)"somehost");
            Assertions.assertEquals((int)0, (int)stats.getAvailable());
            Assertions.assertEquals((int)0, (int)stats.getLeased());
            Assertions.assertEquals((int)0, (int)stats.getPending());
            Assertions.assertFalse((boolean)pool.isShutdown());
        }
    }

    @Test
    void testLeaseRequestTimeout() throws Exception {
        HttpConnection conn1 = (HttpConnection)Mockito.mock(HttpConnection.class);
        try (LaxConnPool pool = new LaxConnPool(1);){
            Future future1 = pool.lease((Object)"somehost", null, Timeout.ofMilliseconds((long)0L), null);
            Future future2 = pool.lease((Object)"somehost", null, Timeout.ofMilliseconds((long)0L), null);
            Future future3 = pool.lease((Object)"somehost", null, Timeout.ofMilliseconds((long)10L), null);
            Assertions.assertTrue((boolean)future1.isDone());
            PoolEntry entry1 = (PoolEntry)future1.get();
            Assertions.assertNotNull((Object)entry1);
            entry1.assignConnection((ModalCloseable)conn1);
            Assertions.assertFalse((boolean)future2.isDone());
            Assertions.assertFalse((boolean)future3.isDone());
            Thread.sleep(100L);
            pool.validatePendingRequests();
            Assertions.assertFalse((boolean)future2.isDone());
            Assertions.assertTrue((boolean)future3.isDone());
        }
    }

    @Test
    void testLeaseRequestCanceled() throws Exception {
        try (LaxConnPool pool = new LaxConnPool(1);){
            Future future1 = pool.lease((Object)"somehost", null, Timeout.ofMilliseconds((long)0L), null);
            Assertions.assertTrue((boolean)future1.isDone());
            PoolEntry entry1 = (PoolEntry)future1.get();
            Assertions.assertNotNull((Object)entry1);
            entry1.assignConnection((ModalCloseable)Mockito.mock(HttpConnection.class));
            Future future2 = pool.lease((Object)"somehost", null, Timeout.ofMilliseconds((long)0L), null);
            future2.cancel(true);
            pool.release(entry1, true);
            PoolStats totals = pool.getTotalStats();
            Assertions.assertEquals((int)1, (int)totals.getAvailable());
            Assertions.assertEquals((int)0, (int)totals.getLeased());
        }
    }

    @Test
    void testGetStatsInvalid() {
        try (LaxConnPool pool = new LaxConnPool(2);){
            Assertions.assertThrows(NullPointerException.class, () -> pool.getStats(null));
        }
    }

    @Test
    void testSetMaxInvalid() {
        try (LaxConnPool pool = new LaxConnPool(2);){
            Assertions.assertThrows(NullPointerException.class, () -> pool.setMaxPerRoute(null, 1));
            Assertions.assertThrows(IllegalArgumentException.class, () -> pool.setDefaultMaxPerRoute(-1));
        }
    }

    @Test
    void testShutdown() {
        LaxConnPool pool = new LaxConnPool(2);
        pool.close(CloseMode.GRACEFUL);
        Assertions.assertThrows(IllegalStateException.class, () -> pool.lease((Object)"somehost", null));
        pool.release(new PoolEntry((Object)"somehost"), true);
    }

    @Test
    void testClose() {
        LaxConnPool pool = new LaxConnPool(2);
        pool.setMaxPerRoute((Object)"someRoute", 2);
        pool.close();
        Assertions.assertThrows(IllegalStateException.class, () -> pool.lease((Object)"someHost", null));
        pool.release(new PoolEntry((Object)"someHost"), true);
    }

    @Test
    void testGetMaxPerRoute() {
        String route = "someRoute";
        int max = 2;
        try (LaxConnPool pool = new LaxConnPool(2);){
            pool.setMaxPerRoute((Object)"someRoute", 2);
            Assertions.assertEquals((int)2, (int)pool.getMaxPerRoute((Object)"someRoute"));
        }
    }
}

