# Dubbo Demo

This directory contains basic Dubbo usages to help Dubbo developers with debugging and smoke test purposes. Check [dubbo-samples](https://github.com/apache/dubbo-samples) repository for more examples that showcase Dubbo's rich features.

## Brief introduction

1. **`dubbo-demo-api`**
   This demo demonstrates the basic usage of Dubbo's RPC protocol, serving as a fundamental example. It showcases how to define and implement a simple RPC service using Dubbo, how to start a server that serves at a specified port and then a consumer that consumes the service. 
2. **`dubbo-demo-springboot`**
   This demo illustrates the integration of Dubbo with Spring Boot, showing how Dubbo services can be utilized and configured within a Spring Boot application. It demonstrates how to configure and manage Dubbo services seamlessly through Spring Boot, making it ideal for developers leveraging the popular Spring Boot framework.
3. **`dubbo-demo-springboot-idl`**
   This demo focuses on showcasing how to use Dubbo with Spring Boot when IDL (Interface Definition Language) files such as Proto files are available. It illustrates how developers can work with Dubbo services defined through IDL, integrating them into a Spring Boot application.

