/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.athena.Athena2Component;

/**
 * Access AWS Athena.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface Aws2AthenaComponentBuilderFactory {

    /**
     * AWS Athena (camel-aws2-athena)
     * Access AWS Athena.
     * 
     * Category: cloud,database
     * Since: 3.4
     * Maven coordinates: org.apache.camel:camel-aws2-athena
     * 
     * @return the dsl builder
     */
    static Aws2AthenaComponentBuilder aws2Athena() {
        return new Aws2AthenaComponentBuilderImpl();
    }

    /**
     * Builder for the AWS Athena component.
     */
    interface Aws2AthenaComponentBuilder extends ComponentBuilder<Athena2Component> {
    
        /**
         * The component configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.aws2.athena.Athena2Configuration&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder configuration(org.apache.camel.component.aws2.athena.Athena2Configuration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        /**
         * The Athena database to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param database the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder database(java.lang.String database) {
            doSetProperty("database", database);
            return this;
        }
    
        
        /**
         * Milliseconds before the next poll for query execution status. See the
         * section Waiting for Query Completion and Retrying Failed Queries to
         * learn more.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 2000
         * Group: producer
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
    
        
        /**
         * Milliseconds before the first poll for query execution status. See
         * the section Waiting for Query Completion and Retrying Failed Queries
         * to learn more.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: producer
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        
        /**
         * Maximum number of times to attempt a query. Set to 1 to disable
         * retries. See the section Waiting for Query Completion and Retrying
         * Failed Queries to learn more.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: producer
         * 
         * @param maxAttempts the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder maxAttempts(int maxAttempts) {
            doSetProperty("maxAttempts", maxAttempts);
            return this;
        }
    
        /**
         * Max number of results to return for the given operation (if supported
         * by the Athena API endpoint). If not set, will use the Athena API
         * default for the given operation.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param maxResults the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder maxResults(java.lang.Integer maxResults) {
            doSetProperty("maxResults", maxResults);
            return this;
        }
    
        /**
         * Pagination token to use in the case where the response from the
         * previous request was truncated.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param nextToken the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder nextToken(java.lang.String nextToken) {
            doSetProperty("nextToken", nextToken);
            return this;
        }
    
        
        /**
         * The Athena API function to call.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.aws2.athena.Athena2Operations&lt;/code&gt; type.
         * 
         * Default: startQueryExecution
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder operation(org.apache.camel.component.aws2.athena.Athena2Operations operation) {
            doSetProperty("operation", operation);
            return this;
        }
    
        /**
         * The location in Amazon S3 where query results are stored, such as
         * s3://path/to/query/bucket/. Ensure this value ends with a forward
         * slash.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param outputLocation the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder outputLocation(java.lang.String outputLocation) {
            doSetProperty("outputLocation", outputLocation);
            return this;
        }
    
        
        /**
         * How query results should be returned. One of StreamList (default -
         * return a GetQueryResultsIterable that can page through all results),
         * SelectList (returns at most 1000 rows at a time, plus a NextToken
         * value as a header than can be used for manual pagination of results),
         * S3Pointer (return an S3 path pointing to the results).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.aws2.athena.Athena2OutputType&lt;/code&gt; type.
         * 
         * Default: StreamList
         * Group: producer
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder outputType(org.apache.camel.component.aws2.athena.Athena2OutputType outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
    
        
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with the uriEndpointOverride option.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder overrideEndpoint(boolean overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
    
        /**
         * The unique ID identifying the query execution.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param queryExecutionId the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder queryExecutionId(java.lang.String queryExecutionId) {
            doSetProperty("queryExecutionId", queryExecutionId);
            return this;
        }
    
        /**
         * The SQL query to run. Except for simple queries, prefer setting this
         * as the body of the Exchange or as a header using
         * Athena2Constants.QUERY_STRING to avoid having to deal with URL
         * encoding issues.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param queryString the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder queryString(java.lang.String queryString) {
            doSetProperty("queryString", queryString);
            return this;
        }
    
        /**
         * The region in which Athena client needs to work. When using this
         * parameter, the configuration will expect the lowercase name of the
         * region (for example ap-east-1).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder region(java.lang.String region) {
            doSetProperty("region", region);
            return this;
        }
    
        
        /**
         * Reset the waitTimeout countdown in the event of a query retry. If set
         * to true, potential max time spent waiting for queries is equal to
         * waitTimeout x maxAttempts. See the section Waiting for Query
         * Completion and Retrying Failed Queries to learn more.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param resetWaitTimeoutOnRetry the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder resetWaitTimeoutOnRetry(boolean resetWaitTimeoutOnRetry) {
            doSetProperty("resetWaitTimeoutOnRetry", resetWaitTimeoutOnRetry);
            return this;
        }
    
        
        /**
         * Optional comma separated list of error types to retry the query for.
         * Use: 'retryable' to retry all retryable failure conditions (e.g.
         * generic errors and resources exhausted), 'generic' to retry
         * 'GENERIC_INTERNAL_ERROR' failures, 'exhausted' to retry queries that
         * have exhausted resource limits, 'always' to always retry regardless
         * of failure condition, or 'never' or null to never retry (default).
         * See the section Waiting for Query Completion and Retrying Failed
         * Queries to learn more.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: never
         * Group: producer
         * 
         * @param retry the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder retry(java.lang.String retry) {
            doSetProperty("retry", retry);
            return this;
        }
    
        /**
         * Set the overriding uri endpoint. This option needs to be used in
         * combination with overrideEndpoint option.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param uriEndpointOverride the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder uriEndpointOverride(java.lang.String uriEndpointOverride) {
            doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }
    
        /**
         * Optional max wait time in millis to wait for a successful query
         * completion. See the section Waiting for Query Completion and Retrying
         * Failed Queries to learn more.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param waitTimeout the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder waitTimeout(long waitTimeout) {
            doSetProperty("waitTimeout", waitTimeout);
            return this;
        }
    
        /**
         * The workgroup to use for running the query.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param workGroup the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder workGroup(java.lang.String workGroup) {
            doSetProperty("workGroup", workGroup);
            return this;
        }
    
        /**
         * The AmazonAthena instance to use as the client.
         * 
         * The option is a:
         * &lt;code&gt;software.amazon.awssdk.services.athena.AthenaClient&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param amazonAthenaClient the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder amazonAthenaClient(software.amazon.awssdk.services.athena.AthenaClient amazonAthenaClient) {
            doSetProperty("amazonAthenaClient", amazonAthenaClient);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        /**
         * A unique string to ensure issues queries are idempotent. It is
         * unlikely you will need to set this.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param clientRequestToken the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder clientRequestToken(java.lang.String clientRequestToken) {
            doSetProperty("clientRequestToken", clientRequestToken);
            return this;
        }
    
        
        /**
         * Include useful trace information at the beginning of queries as an
         * SQL comment (prefixed with --).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeTrace the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder includeTrace(boolean includeTrace) {
            doSetProperty("includeTrace", includeTrace);
            return this;
        }
    
        
        /**
         * Used for enabling or disabling all consumer based health checks from
         * this component.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: health
         * 
         * @param healthCheckConsumerEnabled the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }
    
        
        /**
         * Used for enabling or disabling all producer based health checks from
         * this component. Notice: Camel has by default disabled all producer
         * based health-checks. You can turn on producer checks globally by
         * setting camel.health.producersEnabled=true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: health
         * 
         * @param healthCheckProducerEnabled the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }
    
        /**
         * To define a proxy host when instantiating the Athena client.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder proxyHost(java.lang.String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
    
        /**
         * To define a proxy port when instantiating the Athena client.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder proxyPort(java.lang.Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
    
        
        /**
         * To define a proxy protocol when instantiating the Athena client.
         * 
         * The option is a:
         * &lt;code&gt;software.amazon.awssdk.core.Protocol&lt;/code&gt; type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder proxyProtocol(software.amazon.awssdk.core.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
    
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder accessKey(java.lang.String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
    
        /**
         * The encryption type to use when storing query results in S3. One of
         * SSE_S3, SSE_KMS, or CSE_KMS.
         * 
         * The option is a:
         * &lt;code&gt;software.amazon.awssdk.services.athena.model.EncryptionOption&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param encryptionOption the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder encryptionOption(software.amazon.awssdk.services.athena.model.EncryptionOption encryptionOption) {
            doSetProperty("encryptionOption", encryptionOption);
            return this;
        }
    
        /**
         * For SSE-KMS and CSE-KMS, this is the KMS key ARN or ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param kmsKey the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder kmsKey(java.lang.String kmsKey) {
            doSetProperty("kmsKey", kmsKey);
            return this;
        }
    
        /**
         * If using a profile credentials provider, this parameter will set the
         * profile name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param profileCredentialsName the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder profileCredentialsName(java.lang.String profileCredentialsName) {
            doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }
    
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder secretKey(java.lang.String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
    
        /**
         * Amazon AWS Session Token used when the user needs to assume an IAM
         * role.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sessionToken the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder sessionToken(java.lang.String sessionToken) {
            doSetProperty("sessionToken", sessionToken);
            return this;
        }
    
        
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
    
        
        /**
         * Set whether the Athena client should expect to load credentials
         * through a default credentials provider or to expect static
         * credentials to be passed in.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
    
        
        /**
         * Set whether the Athena client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
    
        
        /**
         * Set whether the Athena client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume an IAM role for doing operations in Athena.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default Aws2AthenaComponentBuilder useSessionCredentials(boolean useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }

    class Aws2AthenaComponentBuilderImpl
            extends AbstractComponentBuilder<Athena2Component>
            implements Aws2AthenaComponentBuilder {
        @Override
        protected Athena2Component buildConcreteComponent() {
            return new Athena2Component();
        }
        private org.apache.camel.component.aws2.athena.Athena2Configuration getOrCreateConfiguration(Athena2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.aws2.athena.Athena2Configuration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "configuration": ((Athena2Component) component).setConfiguration((org.apache.camel.component.aws2.athena.Athena2Configuration) value); return true;
            case "database": getOrCreateConfiguration((Athena2Component) component).setDatabase((java.lang.String) value); return true;
            case "delay": getOrCreateConfiguration((Athena2Component) component).setDelay((long) value); return true;
            case "initialDelay": getOrCreateConfiguration((Athena2Component) component).setInitialDelay((long) value); return true;
            case "lazyStartProducer": ((Athena2Component) component).setLazyStartProducer((boolean) value); return true;
            case "maxAttempts": getOrCreateConfiguration((Athena2Component) component).setMaxAttempts((int) value); return true;
            case "maxResults": getOrCreateConfiguration((Athena2Component) component).setMaxResults((java.lang.Integer) value); return true;
            case "nextToken": getOrCreateConfiguration((Athena2Component) component).setNextToken((java.lang.String) value); return true;
            case "operation": getOrCreateConfiguration((Athena2Component) component).setOperation((org.apache.camel.component.aws2.athena.Athena2Operations) value); return true;
            case "outputLocation": getOrCreateConfiguration((Athena2Component) component).setOutputLocation((java.lang.String) value); return true;
            case "outputType": getOrCreateConfiguration((Athena2Component) component).setOutputType((org.apache.camel.component.aws2.athena.Athena2OutputType) value); return true;
            case "overrideEndpoint": getOrCreateConfiguration((Athena2Component) component).setOverrideEndpoint((boolean) value); return true;
            case "queryExecutionId": getOrCreateConfiguration((Athena2Component) component).setQueryExecutionId((java.lang.String) value); return true;
            case "queryString": getOrCreateConfiguration((Athena2Component) component).setQueryString((java.lang.String) value); return true;
            case "region": getOrCreateConfiguration((Athena2Component) component).setRegion((java.lang.String) value); return true;
            case "resetWaitTimeoutOnRetry": getOrCreateConfiguration((Athena2Component) component).setResetWaitTimeoutOnRetry((boolean) value); return true;
            case "retry": getOrCreateConfiguration((Athena2Component) component).setRetry((java.lang.String) value); return true;
            case "uriEndpointOverride": getOrCreateConfiguration((Athena2Component) component).setUriEndpointOverride((java.lang.String) value); return true;
            case "waitTimeout": getOrCreateConfiguration((Athena2Component) component).setWaitTimeout((long) value); return true;
            case "workGroup": getOrCreateConfiguration((Athena2Component) component).setWorkGroup((java.lang.String) value); return true;
            case "amazonAthenaClient": getOrCreateConfiguration((Athena2Component) component).setAmazonAthenaClient((software.amazon.awssdk.services.athena.AthenaClient) value); return true;
            case "autowiredEnabled": ((Athena2Component) component).setAutowiredEnabled((boolean) value); return true;
            case "clientRequestToken": getOrCreateConfiguration((Athena2Component) component).setClientRequestToken((java.lang.String) value); return true;
            case "includeTrace": getOrCreateConfiguration((Athena2Component) component).setIncludeTrace((boolean) value); return true;
            case "healthCheckConsumerEnabled": ((Athena2Component) component).setHealthCheckConsumerEnabled((boolean) value); return true;
            case "healthCheckProducerEnabled": ((Athena2Component) component).setHealthCheckProducerEnabled((boolean) value); return true;
            case "proxyHost": getOrCreateConfiguration((Athena2Component) component).setProxyHost((java.lang.String) value); return true;
            case "proxyPort": getOrCreateConfiguration((Athena2Component) component).setProxyPort((java.lang.Integer) value); return true;
            case "proxyProtocol": getOrCreateConfiguration((Athena2Component) component).setProxyProtocol((software.amazon.awssdk.core.Protocol) value); return true;
            case "accessKey": getOrCreateConfiguration((Athena2Component) component).setAccessKey((java.lang.String) value); return true;
            case "encryptionOption": getOrCreateConfiguration((Athena2Component) component).setEncryptionOption((software.amazon.awssdk.services.athena.model.EncryptionOption) value); return true;
            case "kmsKey": getOrCreateConfiguration((Athena2Component) component).setKmsKey((java.lang.String) value); return true;
            case "profileCredentialsName": getOrCreateConfiguration((Athena2Component) component).setProfileCredentialsName((java.lang.String) value); return true;
            case "secretKey": getOrCreateConfiguration((Athena2Component) component).setSecretKey((java.lang.String) value); return true;
            case "sessionToken": getOrCreateConfiguration((Athena2Component) component).setSessionToken((java.lang.String) value); return true;
            case "trustAllCertificates": getOrCreateConfiguration((Athena2Component) component).setTrustAllCertificates((boolean) value); return true;
            case "useDefaultCredentialsProvider": getOrCreateConfiguration((Athena2Component) component).setUseDefaultCredentialsProvider((boolean) value); return true;
            case "useProfileCredentialsProvider": getOrCreateConfiguration((Athena2Component) component).setUseProfileCredentialsProvider((boolean) value); return true;
            case "useSessionCredentials": getOrCreateConfiguration((Athena2Component) component).setUseSessionCredentials((boolean) value); return true;
            default: return false;
            }
        }
    }
}