/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.lang.reflect.Constructor;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.processor.BaseProcessorSupport;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.util.ObjectHelper;

public class ThrowExceptionProcessor
extends BaseProcessorSupport
implements Traceable,
IdAware,
RouteIdAware,
CamelContextAware {
    private String id;
    private String routeId;
    private CamelContext camelContext;
    private Expression simple;
    private final Exception exception;
    private final Class<? extends Exception> type;
    private final String message;

    public ThrowExceptionProcessor(Exception exception) {
        this(exception, null, null);
    }

    public ThrowExceptionProcessor(Exception exception, Class<? extends Exception> type, String message) {
        this.exception = exception;
        this.type = type;
        this.message = message;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        Exception cause = this.exception;
        try {
            if (this.message != null && this.type != null) {
                String text = (String)this.simple.evaluate(exchange, String.class);
                Constructor<? extends Exception> constructor = this.type.getConstructor(String.class);
                cause = constructor.newInstance(text);
                exchange.setException((Throwable)cause);
            } else if (cause == null && this.type != null) {
                Constructor<? extends Exception> constructor = this.type.getDeclaredConstructor(new Class[0]);
                cause = constructor.newInstance(new Object[0]);
                exchange.setException((Throwable)cause);
            } else {
                exchange.setException((Throwable)cause);
            }
        }
        catch (Exception e) {
            Class<Exception> exceptionClass = this.exception != null ? this.exception.getClass() : this.type;
            exchange.setException((Throwable)new CamelExchangeException("Error creating new instance of " + String.valueOf(exceptionClass), exchange, (Throwable)e));
        }
        callback.done(true);
        return true;
    }

    public String getTraceLabel() {
        String className = this.exception == null ? this.type.getSimpleName() : this.exception.getClass().getSimpleName();
        return "throwException[" + className + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public Exception getException() {
        return this.exception;
    }

    public Class<? extends Exception> getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String toString() {
        return this.id;
    }

    protected void doInit() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext", (Object)((Object)this));
        if (this.message != null) {
            this.simple = this.camelContext.resolveLanguage("simple").createExpression(this.message);
        }
    }
}

