/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.EndpointKey;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.CompoundIterator;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.LRUCacheFactory;
import org.apache.camel.util.ServiceHelper;

public class DefaultEndpointRegistry
extends AbstractMap<EndpointKey, Endpoint>
implements EndpointRegistry<EndpointKey> {
    private static final long serialVersionUID = 1L;
    private Map<EndpointKey, Endpoint> dynamicMap;
    private Map<EndpointKey, Endpoint> staticMap;
    private final CamelContext context;
    private int maxCacheSize;

    public DefaultEndpointRegistry(CamelContext context) {
        this.maxCacheSize = CamelContextHelper.getMaximumEndpointCacheSize(context);
        this.dynamicMap = LRUCacheFactory.newLRUCache(this.maxCacheSize, this.maxCacheSize, false);
        this.staticMap = new ConcurrentHashMap<EndpointKey, Endpoint>();
        this.context = context;
    }

    public DefaultEndpointRegistry(CamelContext context, Map<EndpointKey, Endpoint> endpoints) {
        this(context);
        this.putAll(endpoints);
    }

    @Override
    public void start() throws Exception {
        if (this.dynamicMap instanceof LRUCache) {
            ((LRUCache)this.dynamicMap).resetStatistics();
        }
    }

    @Override
    public Endpoint get(Object o) {
        Endpoint answer = this.staticMap.get(o);
        if (answer == null && (answer = this.dynamicMap.get(o)) != null && (this.context.isSetupRoutes() || this.context.isStartingRoutes())) {
            this.dynamicMap.remove(o);
            this.staticMap.put((EndpointKey)o, answer);
        }
        return answer;
    }

    @Override
    public Endpoint put(EndpointKey key, Endpoint endpoint) {
        Endpoint answer = this.staticMap.remove(key);
        if (answer != null) {
            this.staticMap.put(key, endpoint);
            return answer;
        }
        answer = this.dynamicMap.remove(key);
        if (answer != null) {
            this.dynamicMap.put(key, endpoint);
            return answer;
        }
        answer = this.context.isSetupRoutes() || this.context.isStartingRoutes() ? this.staticMap.put(key, endpoint) : this.dynamicMap.put(key, endpoint);
        return answer;
    }

    @Override
    public boolean containsKey(Object o) {
        return this.staticMap.containsKey(o) || this.dynamicMap.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.staticMap.containsValue(o) || this.dynamicMap.containsValue(o);
    }

    @Override
    public int size() {
        return this.staticMap.size() + this.dynamicMap.size();
    }

    @Override
    public int staticSize() {
        return this.staticMap.size();
    }

    @Override
    public int dynamicSize() {
        return this.dynamicMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.staticMap.isEmpty() && this.dynamicMap.isEmpty();
    }

    @Override
    public Endpoint remove(Object o) {
        Endpoint answer = this.staticMap.remove(o);
        if (answer == null) {
            answer = this.dynamicMap.remove(o);
        }
        return answer;
    }

    @Override
    public void clear() {
        this.staticMap.clear();
        this.dynamicMap.clear();
    }

    @Override
    public Set<Map.Entry<EndpointKey, Endpoint>> entrySet() {
        return new AbstractSet<Map.Entry<EndpointKey, Endpoint>>(){

            @Override
            public Iterator<Map.Entry<EndpointKey, Endpoint>> iterator() {
                return new CompoundIterator<Map.Entry<EndpointKey, Endpoint>>(Arrays.asList(DefaultEndpointRegistry.this.staticMap.entrySet().iterator(), DefaultEndpointRegistry.this.dynamicMap.entrySet().iterator()));
            }

            @Override
            public int size() {
                return DefaultEndpointRegistry.this.staticMap.size() + DefaultEndpointRegistry.this.dynamicMap.size();
            }
        };
    }

    @Override
    public int getMaximumCacheSize() {
        return this.maxCacheSize;
    }

    @Override
    public void purge() {
        this.dynamicMap.clear();
    }

    @Override
    public void cleanUp() {
        if (this.dynamicMap instanceof LRUCache) {
            ((LRUCache)this.dynamicMap).cleanUp();
        }
    }

    @Override
    public boolean isStatic(String key) {
        return this.staticMap.containsKey(new EndpointKey(key));
    }

    @Override
    public boolean isDynamic(String key) {
        return this.dynamicMap.containsKey(new EndpointKey(key));
    }

    @Override
    public void stop() throws Exception {
        ServiceHelper.stopServices(this.staticMap.values());
        ServiceHelper.stopServices(this.values());
        this.purge();
    }

    @Override
    public String toString() {
        return "EndpointRegistry for " + this.context.getName() + ", capacity: " + this.maxCacheSize;
    }
}

